/*
 * Decompiled with CFR 0.152.
 */
package protocol.request;

import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class VerifySignedDataReq
extends ASN1Object {
    private ASN1Integer type;
    private X509Certificate cert;
    private ASN1OctetString certSN;
    private ASN1Integer inDataLen;
    private ASN1OctetString inData;
    private ASN1OctetString signature;
    private ASN1Integer verifyLevel;

    public VerifySignedDataReq(Integer type, X509Certificate cert, String certSN, byte[] inData, byte[] signature, int verifyLevel) {
        this.type = new ASN1Integer((long)type.intValue());
        this.cert = cert;
        this.certSN = new DEROctetString(certSN.getBytes(StandardCharsets.UTF_8));
        this.inDataLen = new ASN1Integer((long)inData.length);
        this.inData = new DEROctetString(inData);
        this.signature = new DEROctetString(signature);
        this.verifyLevel = new ASN1Integer((long)verifyLevel);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.type);
        try {
            vector.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)ASN1Primitive.fromByteArray((byte[])this.cert.getEncoded())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        vector.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)this.certSN));
        vector.add((ASN1Encodable)this.inDataLen);
        vector.add((ASN1Encodable)this.inData);
        vector.add((ASN1Encodable)this.signature);
        vector.add((ASN1Encodable)this.verifyLevel);
        return new DERSequence(vector);
    }
}

