/*
 * Decompiled with CFR 0.152.
 */
package protocol.requestExt;

import java.nio.charset.StandardCharsets;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class InternalSign
extends ASN1Object {
    private ASN1Integer signMethod;
    private ASN1Integer hashalg;
    private ASN1Integer keyIndex;
    private ASN1OctetString keyValue;
    private ASN1Integer hashValueLen;
    private ASN1OctetString hashValue;

    public InternalSign() {
    }

    public InternalSign(int keyIndex, String keyValue, long hashalg, int hashValueLen, String hashValue) {
        this.signMethod = new ASN1Integer(262400L);
        this.hashalg = new ASN1Integer(hashalg);
        this.keyIndex = new ASN1Integer((long)keyIndex);
        this.keyValue = new DEROctetString(keyValue.getBytes(StandardCharsets.UTF_8));
        this.hashValueLen = new ASN1Integer((long)hashValueLen);
        this.hashValue = new DEROctetString(hashValue.getBytes(StandardCharsets.UTF_8));
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.signMethod);
        vector.add((ASN1Encodable)this.hashalg);
        vector.add((ASN1Encodable)this.keyIndex);
        vector.add((ASN1Encodable)this.keyValue);
        vector.add((ASN1Encodable)this.hashValueLen);
        vector.add((ASN1Encodable)this.hashValue);
        return new DERSequence(vector);
    }
}

