/*
 * Decompiled with CFR 0.152.
 */
package protocol.response;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class ExportAppCertByUsageResp
extends ASN1Object {
    private ASN1Integer respValue;
    private X509Certificate certificate;

    public ExportAppCertByUsageResp(ASN1Encodable instance) throws Exception {
        DERTaggedObject derTaggedObject = (DERTaggedObject)instance;
        if (derTaggedObject.getObject() instanceof ASN1Integer) {
            this.respValue = ASN1Integer.getInstance((Object)derTaggedObject.getObjectParser(0, true));
        } else {
            ASN1Sequence asn1Sequence = (ASN1Sequence)derTaggedObject.getObject();
            this.respValue = ASN1Integer.getInstance((Object)asn1Sequence.getObjectAt(0));
            byte[] encoded = asn1Sequence.getObjectAt(1).toASN1Primitive().getEncoded();
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(encoded);
            this.certificate = (X509Certificate)cf.generateCertificate(inStream);
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.respValue);
        try {
            vector.add((ASN1Encodable)ASN1Primitive.fromByteArray((byte[])this.certificate.getEncoded()));
        }
        catch (Exception e) {
            return null;
        }
        return new DERSequence(vector);
    }

    public ASN1Integer getRespValue() {
        return this.respValue;
    }

    public void setRespValue(ASN1Integer respValue) {
        this.respValue = respValue;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }
}

