/*
 * Decompiled with CFR 0.152.
 */
package protocol.session;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import protocol.AbsApiResponse;
import protocol.response.GMT0029_RelateAppContext;

public class SessionResp
extends AbsApiResponse {
    private ASN1Integer respValue;
    private GMT0029_RelateAppContext appContext;

    public SessionResp(ASN1Encodable asn1Encodable) throws Exception {
        DERTaggedObject dlTaggedObject = (DERTaggedObject)asn1Encodable.toASN1Primitive();
        if (dlTaggedObject.getObject() instanceof ASN1Integer) {
            this.respValue = ASN1Integer.getInstance((Object)dlTaggedObject.getObjectParser(0, true));
        } else {
            ASN1Sequence asn1Sequence = (ASN1Sequence)dlTaggedObject.getObject();
            this.respValue = ASN1Integer.getInstance((Object)asn1Sequence.getObjectAt(0));
            this.appContext = new GMT0029_RelateAppContext((ASN1Sequence)asn1Sequence.getObjectAt(1));
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.respValue);
        try {
            vector.add((ASN1Encodable)ASN1Primitive.fromByteArray((byte[])this.appContext.getEncoded()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DERSequence(vector);
    }

    public ASN1Integer getRespValue() {
        return this.respValue;
    }

    public void setRespValue(ASN1Integer respValue) {
        this.respValue = respValue;
    }

    public GMT0029_RelateAppContext getAppContext() {
        return this.appContext;
    }

    public void setAppContext(GMT0029_RelateAppContext appContext) {
        this.appContext = appContext;
    }
}

