/*
 * Decompiled with CFR 0.152.
 */
package protocol.timestamp;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA1DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA256DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import common.SvsOidEnum;
import java.io.IOException;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import utils.Base64Utils;

public class CreateTimeStampReq {
    public String CreateTimeStampReq(byte[] inData, long signMethod, boolean certReq) {
        TimeStampRequestGenerator reqgen = new TimeStampRequestGenerator();
        reqgen.setCertReq(true);
        TimeStampRequest req = null;
        try {
            if (signMethod == SvsOidEnum.SM3_SM2 || signMethod == SvsOidEnum.SM3_RSA) {
                byte[] digest = GMSSLSM3DigestUtils.digest((byte[])inData);
                req = reqgen.generate(TSPAlgorithms.SM3, digest);
            } else if (signMethod == SvsOidEnum.SHA1_RSA) {
                byte[] digest = GMSSLSHA1DigestUtils.digest((byte[])inData);
                req = reqgen.generate(TSPAlgorithms.SHA1, digest);
            } else if (signMethod == SvsOidEnum.SHA256_RSA) {
                byte[] digest = GMSSLSHA256DigestUtils.digest((byte[])inData);
                req = reqgen.generate(TSPAlgorithms.SHA256, digest);
            }
            return Base64Utils.encode(req.getEncoded());
        }
        catch (IOException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

