/*
 * Decompiled with CFR 0.152.
 */
package protocol.timestamp;

import java.nio.charset.StandardCharsets;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class CreateTimeStampRespReq
extends ASN1Object {
    private ASN1OctetString tsReq;
    private ASN1Integer signAlgo;
    private ASN1Integer keyIndex;
    private ASN1Integer keybits;
    private ASN1OctetString keyValue;

    public CreateTimeStampRespReq(byte[] tsReq, long signAlgo, int keyIndex, String keyValue) {
        this.tsReq = new DEROctetString(tsReq);
        this.signAlgo = new ASN1Integer(signAlgo);
        this.keyIndex = new ASN1Integer((long)keyIndex);
        this.keybits = new ASN1Integer(256L);
        this.keyValue = new DEROctetString(keyValue.getBytes(StandardCharsets.UTF_8));
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.tsReq);
        vector.add((ASN1Encodable)this.signAlgo);
        vector.add((ASN1Encodable)this.keyIndex);
        vector.add((ASN1Encodable)this.keybits);
        vector.add((ASN1Encodable)this.keyValue);
        return new DERSequence(vector);
    }

    public ASN1OctetString getTsReq() {
        return this.tsReq;
    }

    public void setTsReq(ASN1OctetString tsReq) {
        this.tsReq = tsReq;
    }

    public ASN1Integer getSignAlgo() {
        return this.signAlgo;
    }

    public void setSignAlgo(ASN1Integer signAlgo) {
        this.signAlgo = signAlgo;
    }

    public ASN1Integer getKeyIndex() {
        return this.keyIndex;
    }

    public void setKeyIndex(ASN1Integer keyIndex) {
        this.keyIndex = keyIndex;
    }

    public ASN1OctetString getKeyValue() {
        return this.keyValue;
    }

    public void setKeyValue(ASN1OctetString keyValue) {
        this.keyValue = keyValue;
    }

    public ASN1Integer getKeybits() {
        return this.keybits;
    }

    public void setKeybits(ASN1Integer keybits) {
        this.keybits = keybits;
    }
}

