/*
 * Decompiled with CFR 0.152.
 */
package protocol.timestamp;

import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class VerifyTimeStampReq
extends ASN1Object {
    private ASN1OctetString tsResp;
    private ASN1Integer signAlgo;
    private ASN1Integer level;
    private X509Certificate cert;

    public VerifyTimeStampReq(byte[] tsResp, long signAlgo, int level, X509Certificate cert) {
        this.tsResp = new DEROctetString(tsResp);
        this.signAlgo = new ASN1Integer(signAlgo);
        this.level = new ASN1Integer((long)level);
        this.cert = cert;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.tsResp);
        vector.add((ASN1Encodable)this.signAlgo);
        vector.add((ASN1Encodable)this.level);
        try {
            if (this.cert != null) {
                vector.add((ASN1Encodable)ASN1Primitive.fromByteArray((byte[])this.cert.getEncoded()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DERSequence(vector);
    }

    public ASN1OctetString getTsResp() {
        return this.tsResp;
    }

    public void setTsResp(ASN1OctetString tsResp) {
        this.tsResp = tsResp;
    }

    public ASN1Integer getSignAlgo() {
        return this.signAlgo;
    }

    public void setSignAlgo(ASN1Integer signAlgo) {
        this.signAlgo = signAlgo;
    }

    public ASN1Integer getLevel() {
        return this.level;
    }

    public void setLevel(ASN1Integer level) {
        this.level = level;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public void setCert(X509Certificate cert) {
        this.cert = cert;
    }
}

