/*
 * Decompiled with CFR 0.152.
 */
package socket;

import common.SofInstance;
import execption.errorCode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import protocol.SvsRequest;
import protocol.TLvDataBody;
import socket.TLV;
import socket.TLVTools;

public class SocketFactory {
    private static errorCode err = new errorCode();

    public static Socket getSocketConnection(String hostName, Integer port, Integer timeOut) throws IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(10000);
        socket.setReuseAddress(true);
        socket.setKeepAlive(true);
        socket.setReceiveBufferSize(0x4000000);
        socket.setSendBufferSize(0x4000000);
        try {
            socket.connect(new InetSocketAddress(hostName, (int)port), timeOut);
        }
        catch (Exception e) {
            return null;
        }
        return socket;
    }

    public static void releaseSocketResource(Socket socket) {
        if (socket != null && !socket.isClosed()) {
            try {
                socket.getInputStream().close();
                socket.close();
            }
            catch (Exception e) {
                System.out.println("\u91ca\u653e\u8d44\u6e90\u5f02\u5e38");
            }
        }
    }

    public static int sendRequestBody(Socket socket, byte[] requestBody) {
        BufferedOutputStream writer = null;
        try {
            writer = new BufferedOutputStream(socket.getOutputStream());
            writer.write(requestBody);
            writer.flush();
        }
        catch (IOException e) {
            return -1;
        }
        return 0;
    }

    public static TLvDataBody getResponseBody(Socket socket) {
        try {
            int i;
            BufferedInputStream reader = new BufferedInputStream(socket.getInputStream());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] tmpByte = new byte[8192];
            TLVTools tlvTools = new TLVTools();
            ArrayList<TLV> tlvList = new ArrayList<TLV>();
            while ((i = reader.read(tmpByte)) != -1) {
                out.write(tmpByte, 0, i);
                List<TLV> unpackDataList = TLVTools.unpack(tlvList, TLVTools.bytesToHex(out.toByteArray()));
                if (unpackDataList.size() != 1) continue;
                TLvDataBody tLvDataBody = new TLvDataBody();
                tLvDataBody.setData(out.toByteArray());
                tLvDataBody.setTlv(unpackDataList.get(0));
                return tLvDataBody;
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public static ASN1Sequence sendAndreceiveBody(SofInstance sof, String funcName, byte[] requestBodyData) throws Exception {
        int sock = SocketFactory.sendRequestBody(sof.getxSession(), requestBodyData);
        if (sock != 0) {
            sof.setErrCode(errorCode.SOR_TimeoutErr);
            return null;
        }
        TLvDataBody tlvDataBody = SocketFactory.getResponseBody(sof.getxSession());
        if (tlvDataBody == null) {
            sof.setErrCode(errorCode.SOR_UnknownErr);
            return null;
        }
        return (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])tlvDataBody.getData());
    }

    public static ASN1Sequence processing(Socket socketFd, SvsRequest request) throws Exception {
        int sock = SocketFactory.sendRequestBody(socketFd, request.getEncoded());
        if (sock != 0) {
            return null;
        }
        TLvDataBody tlvDataBody = SocketFactory.getResponseBody(socketFd);
        if (tlvDataBody == null) {
            return null;
        }
        return (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])tlvDataBody.getData());
    }
}

