/*
 * Decompiled with CFR 0.152.
 */
package socket;

import java.util.List;
import socket.TLV;

public class TLVTools {
    private static char[] HEX_VOCABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static List<TLV> unpack(List<TLV> tlvList, String tlv) {
        int lenValue = 0;
        int tagLen = 0;
        byte[] data = TLVTools.hexStrToBytes(tlv);
        for (int current = 0; current < data.length; current += lenValue) {
            TLV tlvData = new TLV();
            tagLen = TLVTools.getTagLen(data, current);
            tlvData.setTag(TLVTools.getTagToInt(data, current, tagLen));
            if ((data[current += tagLen] & 0x80) == 128) {
                int tmpLen = data[current] & 0x7F;
                switch (tmpLen) {
                    case 1: {
                        lenValue = data[current + 1] & 0xFF;
                        break;
                    }
                    case 2: {
                        lenValue = (data[current + 1] << 8 & 0xFF00) + (data[current + 2] & 0xFF);
                    }
                }
                current += tmpLen + 1;
            } else {
                lenValue = data[current] & 0xFF;
                ++current;
            }
            tlvData.setLen(lenValue);
            byte[] temp = new byte[lenValue];
            System.arraycopy(data, current, temp, 0, lenValue);
            tlvData.setValue(temp);
            tlvList.add(tlvData);
        }
        return tlvList;
    }

    public static byte[] hexStrToBytes(String data) {
        if (data == null || "".equals(data)) {
            return null;
        }
        int len = data.length() / 2;
        byte[] result = new byte[len];
        char[] chArr = data.toCharArray();
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            result[i] = (byte)(TLVTools.toByte(chArr[pos]) << 4 | TLVTools.toByte(chArr[pos + 1]));
        }
        return result;
    }

    public static int getTagLen(byte[] data, int flag) {
        byte b;
        int tagLen = 1;
        for (int i = 0; i < 2 && ((b = data[i + flag]) & 0xF) == 15; ++i) {
            ++tagLen;
        }
        return tagLen;
    }

    public static byte toByte(char c) {
        byte b = (byte)"0123456789ABCDEF".indexOf(c);
        return b;
    }

    public static int getTagToInt(byte[] data, int flag, int len) {
        int mask = 255;
        int temp = 0;
        int result = 0;
        len = Math.min(len, 4);
        for (int i = 0; i < len; ++i) {
            result <<= 8;
            temp = data[flag + i] & mask;
            result |= temp;
        }
        return result;
    }

    public static String bytesToHex(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (byte b : data) {
            int high = b >> 4 & 0xF;
            int low = b & 0xF;
            sb.append(HEX_VOCABLE[high]);
            sb.append(HEX_VOCABLE[low]);
        }
        return sb.toString();
    }
}

