/*
 * Decompiled with CFR 0.152.
 */
package utils;

import common.SvsOidEnum;
import encapsulation.GMT0010_EncryptedContentInfo;
import encapsulation.GMT0010_EnvelopedData;
import encapsulation.GMT0010_RecipientInfo;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import utils.Base64Utils;

public class Asn1Util {
    public static SignerInfo generateSignerInfo(long alg, AlgorithmIdentifier digestAlgorithm, AlgorithmIdentifier digestEncryptionAlgorithm, IssuerAndSerialNumber issuerAndSerialNumber, byte[] encryptedDigest) throws Exception {
        SignerIdentifier signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
        ASN1Set authenticatedAttributes = null;
        return new SignerInfo(signerIdentifier, digestAlgorithm, authenticatedAttributes, digestEncryptionAlgorithm, (ASN1OctetString)new DEROctetString(encryptedDigest), authenticatedAttributes);
    }

    public static SignedData generateSignedData(long alg, byte[] inData, IssuerAndSerialNumber issuerAndSerialNumber, byte[] encryptedDigest, byte[] signCert) throws Exception {
        AlgorithmIdentifier digestAlgorithm = null;
        AlgorithmIdentifier digestEncryptionAlgorithm = null;
        if (alg == SvsOidEnum.SM3_SM2) {
            digestAlgorithm = new AlgorithmIdentifier(GMObjectIdentifiers.sm3);
            digestEncryptionAlgorithm = new AlgorithmIdentifier(SvsOidEnum.signedData);
        } else if (alg == SvsOidEnum.SM3_RSA) {
            digestAlgorithm = new AlgorithmIdentifier(GMObjectIdentifiers.sm3);
            digestEncryptionAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.signedData);
        } else if (alg == SvsOidEnum.SHA1_RSA) {
            digestAlgorithm = new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1);
            digestEncryptionAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.signedData);
        } else if (alg == SvsOidEnum.SHA256_RSA) {
            digestAlgorithm = new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1);
            digestEncryptionAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.signedData);
        }
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        digestAlgs.add((ASN1Encodable)digestAlgorithm);
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, (ASN1Encodable)new DEROctetString(inData));
        ASN1EncodableVector signCerts = new ASN1EncodableVector();
        signCerts.add((ASN1Encodable)new DEROctetString(signCert));
        SignerInfo signerInfo = Asn1Util.generateSignerInfo(alg, digestAlgorithm, digestEncryptionAlgorithm, issuerAndSerialNumber, encryptedDigest);
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        signerInfos.add((ASN1Encodable)signerInfo);
        return new SignedData((ASN1Set)new DERSet(digestAlgs), contentInfo, (ASN1Set)new DERSet(signCerts), (ASN1Set)new DERSet(), (ASN1Set)new DERSet(signerInfos));
    }

    public static EncryptedContentInfo generateEncryptedContentInfo(long symmAlg, byte[] encryptedContent, ASN1OctetString iv) throws Exception {
        AlgorithmIdentifier contentEncryptionAlgorithm = null;
        ASN1ObjectIdentifier contentType = PKCSObjectIdentifiers.envelopedData;
        ASN1ObjectIdentifier sm_scheme = new ASN1ObjectIdentifier("1.2.156.10197.1");
        contentEncryptionAlgorithm = new AlgorithmIdentifier(sm_scheme.branch(String.valueOf(symmAlg)), (ASN1Encodable)iv);
        return new EncryptedContentInfo(contentType, contentEncryptionAlgorithm, (ASN1OctetString)new DEROctetString(encryptedContent));
    }

    public static GMT0010_EncryptedContentInfo generateGmtEncryptedContentInfo(long symmAlg, byte[] encryptedContent) throws Exception {
        AlgorithmIdentifier contentEncryptionAlgorithm = null;
        AlgorithmIdentifier contentType = new AlgorithmIdentifier(SvsOidEnum.envelopedData);
        ASN1ObjectIdentifier sm_scheme = new ASN1ObjectIdentifier("1.2.156.10197.1");
        contentEncryptionAlgorithm = new AlgorithmIdentifier(sm_scheme.branch(String.valueOf(symmAlg)));
        return new GMT0010_EncryptedContentInfo(contentType, contentEncryptionAlgorithm, encryptedContent, "", "");
    }

    public static KeyTransRecipientInfo generateKeyTransRecipientInfo(long alg, IssuerAndSerialNumber issuerAndSerialNumber, byte[] symmkeyencrypted) throws Exception {
        RecipientIdentifier recipientIdentifier = new RecipientIdentifier(issuerAndSerialNumber);
        AlgorithmIdentifier keyEncryptionAlgorithm = null;
        DEROctetString encryptedKey = new DEROctetString(symmkeyencrypted);
        keyEncryptionAlgorithm = alg == SvsOidEnum.SM3_SM2 ? new AlgorithmIdentifier(GMObjectIdentifiers.sm2encrypt) : new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption);
        return new KeyTransRecipientInfo(recipientIdentifier, keyEncryptionAlgorithm, (ASN1OctetString)encryptedKey);
    }

    public static GMT0010_EnvelopedData generateGmtEnvelopedData(long alg, long symmAlg, IssuerAndSerialNumber issuerAndSerialNumber, byte[] symmkeyencrypted, byte[] encryptedContent, ASN1OctetString iv) throws Exception {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.197.1.301.3"), (ASN1Encodable)iv);
        GMT0010_RecipientInfo gmt0010RecipientInfo = new GMT0010_RecipientInfo(issuerAndSerialNumber, algorithmIdentifier, symmkeyencrypted);
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        recipientInfos.add((ASN1Encodable)gmt0010RecipientInfo);
        GMT0010_EncryptedContentInfo gmt0010EncryptedContentInfo = Asn1Util.generateGmtEncryptedContentInfo(symmAlg, encryptedContent);
        return new GMT0010_EnvelopedData((ASN1Set)new DERSet(recipientInfos), gmt0010EncryptedContentInfo);
    }

    public static EnvelopedData generateEnvelopedData(long alg, long symmAlg, IssuerAndSerialNumber issuerAndSerialNumber, byte[] symmkeyencrypted, byte[] encryptedContent, ASN1OctetString iv) throws Exception {
        RecipientInfo recipientInfo = new RecipientInfo(Asn1Util.generateKeyTransRecipientInfo(alg, issuerAndSerialNumber, symmkeyencrypted));
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        recipientInfos.add((ASN1Encodable)recipientInfo);
        EncryptedContentInfo encryptedContentInfo = Asn1Util.generateEncryptedContentInfo(symmAlg, encryptedContent, iv);
        return new EnvelopedData(null, (ASN1Set)new DERSet(recipientInfos), encryptedContentInfo, (ASN1Set)new DERSet());
    }

    public static String packEnvelopedData(X509Certificate x509Certificate, byte[] encryptedkey, byte[] encrypteddate, ASN1OctetString iv, long encMethod) {
        try {
            IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance((Object)x509Certificate.getIssuerDN()), x509Certificate.getSerialNumber());
            if (x509Certificate.getPublicKey().getAlgorithm().equals("RSA")) {
                EnvelopedData envelopedData = Asn1Util.generateEnvelopedData(SvsOidEnum.SGD_RSA, encMethod, issuerAndSerialNumber, encryptedkey, encrypteddate, iv);
                return Base64Utils.encode(envelopedData.getEncoded());
            }
            GMT0010_EnvelopedData gmt0010EnvelopedData = Asn1Util.generateGmtEnvelopedData(SvsOidEnum.SGD_SM2, encMethod, issuerAndSerialNumber, encryptedkey, encrypteddate, iv);
            return Base64Utils.encode(gmt0010EnvelopedData.getEncoded());
        }
        catch (Exception e) {
            return null;
        }
    }
}

