/*
 * Decompiled with CFR 0.152.
 */
package utils;

import cn.hutool.core.map.MapBuilder;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.RandomUtil;
import com.xdja.svs.decrypt.DecryptDataApi;
import common.ApiMethodId;
import common.SofInstance;
import common.SvsOidEnum;
import encapsulation.GMT0010_EnvelopedData;
import encapsulation.GMT0010_RecipientInfo;
import execption.errorCode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import protocol.SvsRequest;
import protocol.encryption.request.MultiEncryptDataFinalReq;
import protocol.encryption.request.MultiEncryptDataInitReq;
import protocol.encryption.request.MultiEncryptDataUpdateReq;
import protocol.encryption.request.SingleDecryptDataReq;
import protocol.encryption.request.SingleEncryptDataReq;
import protocol.encryption.response.MultiDecryptDataFinalResp;
import protocol.encryption.response.MultiDecryptDataInitResp;
import protocol.encryption.response.MultiDecryptDataUpdateResp;
import protocol.encryption.response.MultiEncryptDataFinalResp;
import protocol.encryption.response.MultiEncryptDataInitResp;
import protocol.encryption.response.MultiEncryptDataUpdateResp;
import protocol.encryption.response.SingleDecryptDataResp;
import protocol.encryption.response.SingleEncryptDataResp;
import socket.SocketFactory;
import utils.Asn1Util;

public class EncryptDecryptUtils {
    public static errorCode err = new errorCode();

    public static String singleEncryptData(SofInstance sof, X509Certificate x509Certificate, byte[] inData) {
        long pubkeyType = 0L;
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (publicKey.getAlgorithm().equals("RSA")) {
            pubkeyType = SvsOidEnum.SGD_RSA;
        } else if (publicKey.getAlgorithm().equals("EC")) {
            pubkeyType = SvsOidEnum.SGD_SM2;
        } else {
            sof.setErrCode(errorCode.SOR_CERTENCODEErr);
            return null;
        }
        byte[] randomIv = RandomUtil.randomBytes((int)16);
        SingleEncryptDataReq encryptDataReq = new SingleEncryptDataReq(SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded()), pubkeyType, sof.getEncMethod(), inData, randomIv);
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.SINGLE_ENCRYPT_DATA_REQ.value(), encryptDataReq);
        try {
            ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "SOF_encryptData", svsRequest.getEncoded());
            if (sequence == null) {
                return null;
            }
            SingleEncryptDataResp encryptDataResp = new SingleEncryptDataResp((int)sof.getEncMethod(), sequence.getObjectAt(2));
            long sdkErr = err.singleEncryptoErr(encryptDataResp.getRespValue().getValue().longValue());
            if (sdkErr != (long)errorCode.SOR_OK) {
                sof.setErrCode(sdkErr);
                return null;
            }
            if (encryptDataResp.getCipherText() == null || encryptDataResp.getSymKey() == null) {
                sof.setErrCode(errorCode.SOR_ENCRYPTDATAErr);
                return null;
            }
            String baseEnveloped = Asn1Util.packEnvelopedData(x509Certificate, encryptDataResp.getSymKey().getOctets(), encryptDataResp.getCipherText().getOctets(), encryptDataResp.getIv(), sof.getEncMethod());
            if (baseEnveloped == null) {
                sof.setErrCode(errorCode.SOR_PKCS7ENCODEErr);
                return null;
            }
            return baseEnveloped;
        }
        catch (IOException e) {
            sof.setErrCode(errorCode.SOR_ObjErr);
            return null;
        }
        catch (Exception e) {
            sof.setErrCode(errorCode.SOR_ProviderTypeErr);
            return null;
        }
    }

    public static MultiEncryptDataInitResp multiEncryptDataInit(SofInstance sof, X509Certificate x509Certificate) throws Exception {
        long pubType = 0L;
        pubType = x509Certificate.getPublicKey().getAlgorithm().equals("RSA") ? SvsOidEnum.SGD_RSA : SvsOidEnum.SGD_SM2;
        MultiEncryptDataInitReq encryptDataInitReq = new MultiEncryptDataInitReq(SubjectPublicKeyInfo.getInstance((Object)x509Certificate.getPublicKey().getEncoded()), pubType, sof.getEncMethod());
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.ENCRYPT_DATA_REQ_INIT.value(), encryptDataInitReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "encryptDataInit", svsRequest.getEncoded());
        if (sequence == null) {
            return null;
        }
        MultiEncryptDataInitResp encryptDataInitResp = new MultiEncryptDataInitResp((int)sof.getEncMethod(), sequence.getObjectAt(2));
        if (encryptDataInitResp.getRespValue().getValue().longValue() != (long)errorCode.SOR_OK) {
            return null;
        }
        return encryptDataInitResp;
    }

    public static MultiEncryptDataUpdateResp multiEncryptDataUpdate(SofInstance sof, long symKeyID, byte[] inData, ASN1OctetString iv) throws Exception {
        MultiEncryptDataUpdateReq multiEncryptDataUpdateReq = new MultiEncryptDataUpdateReq(symKeyID, inData, iv);
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.ENCRYPT_DATA_REQ_UPDATE.value(), multiEncryptDataUpdateReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "encryptDataUpdata", svsRequest.getEncoded());
        if (sequence == null) {
            return null;
        }
        MultiEncryptDataUpdateResp multiEncryptDataUpdateResp = new MultiEncryptDataUpdateResp((int)sof.getEncMethod(), sequence.getObjectAt(2));
        if (multiEncryptDataUpdateResp.getRespValue().getValue().longValue() != (long)errorCode.SOR_OK) {
            return null;
        }
        return multiEncryptDataUpdateResp;
    }

    public static MultiEncryptDataFinalResp multiEncryptDataFinal(SofInstance sof, long symKeyID, byte[] inData, ASN1OctetString iv) throws Exception {
        MultiEncryptDataFinalReq multiEncryptDataFinalReq = new MultiEncryptDataFinalReq(symKeyID, inData, iv);
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.ENCRYPT_DATA_REQ_FINAL.value(), multiEncryptDataFinalReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "encryptDataFinal", svsRequest.getEncoded());
        if (sequence == null) {
            return null;
        }
        MultiEncryptDataFinalResp multiEncryptDataFinalResp = new MultiEncryptDataFinalResp(sequence.getObjectAt(2));
        if (multiEncryptDataFinalResp.getRespValue().getValue().longValue() != (long)errorCode.SOR_OK) {
            return null;
        }
        return multiEncryptDataFinalResp;
    }

    public static String multiEncryptData(SofInstance sof, X509Certificate x509Certificate, byte[] inData) {
        try {
            MultiEncryptDataInitResp multiEncryptDataInitResp = EncryptDecryptUtils.multiEncryptDataInit(sof, x509Certificate);
            long symKeyID = multiEncryptDataInitResp.getSymKeyID().getValue().longValue();
            ASN1OctetString iv = multiEncryptDataInitResp.getIv();
            byte[][] split = ArrayUtil.split((byte[])inData, (int)4096);
            int len = inData.length % 4096;
            byte[] tmpIndata = new byte[len];
            MultiEncryptDataUpdateResp multiEncryptDataUpdateResp = null;
            int length = split.length;
            MapBuilder builder = MapUtil.builder();
            Map build = builder.build();
            for (int i = 0; i < length - 1; ++i) {
                if (i == 0) {
                    multiEncryptDataUpdateResp = EncryptDecryptUtils.multiEncryptDataUpdate(sof, symKeyID, split[i], iv);
                    build.put(i, multiEncryptDataUpdateResp.getCipherText().getOctets());
                    continue;
                }
                multiEncryptDataUpdateResp = EncryptDecryptUtils.multiEncryptDataUpdate(sof, symKeyID, split[i], multiEncryptDataUpdateResp.getIv());
                build.put(i, multiEncryptDataUpdateResp.getCipherText().getOctets());
            }
            ArrayUtil.copy((Object)split[length - 1], (Object)tmpIndata, (int)len);
            MultiEncryptDataFinalResp multiEncryptDataFinalResp = EncryptDecryptUtils.multiEncryptDataFinal(sof, symKeyID, tmpIndata, multiEncryptDataUpdateResp.getIv());
            build.put(length - 1, multiEncryptDataFinalResp.getCipherText().getOctets());
            byte[] Ciphertext = new byte[inData.length];
            for (int j = 0; j < build.size(); ++j) {
                if (j == build.size() - 1) {
                    System.arraycopy(tmpIndata, 0, Ciphertext, 4096 * j, tmpIndata.length);
                    continue;
                }
                System.arraycopy(build.get(j), 0, Ciphertext, 4096 * j, 4096);
            }
            String baseEnveloped = Asn1Util.packEnvelopedData(x509Certificate, multiEncryptDataInitResp.getSymKey().getOctets(), Ciphertext, multiEncryptDataFinalResp.getIv(), sof.getEncMethod());
            if (baseEnveloped == null) {
                sof.setErrCode(errorCode.SOR_PKCS7ENCODEErr);
                return null;
            }
            return baseEnveloped;
        }
        catch (Exception e) {
            sof.setErrCode(errorCode.SOR_ENCRYPTDATAErr);
            return null;
        }
    }

    private byte[] getDataCipkeyfromEnvelopedData(byte[] inData) {
        try {
            EnvelopedData envelopedData = EnvelopedData.getInstance((Object)inData);
            byte[] datacipher = envelopedData.getEncryptedContentInfo().getEncryptedContent().getOctets();
            return datacipher;
        }
        catch (Exception e) {
            try {
                GMT0010_EnvelopedData gmt0010EnvelopedData = GMT0010_EnvelopedData.getInstance(inData);
                byte[] datacipher = gmt0010EnvelopedData.getEncryptedContentInfo().getEncryptedcontent().getOctets();
                return datacipher;
            }
            catch (Exception e1) {
                return null;
            }
        }
    }

    private byte[] getSymmkeyfromEnvelopedData(byte[] inData) {
        try {
            EnvelopedData envelopedData = EnvelopedData.getInstance((Object)inData);
            byte[] symmkeycipher = KeyTransRecipientInfo.getInstance((Object)envelopedData.getRecipientInfos().getObjectAt(0)).getEncryptedKey().getOctets();
            return symmkeycipher;
        }
        catch (Exception e) {
            try {
                GMT0010_EnvelopedData gmt0010EnvelopedData = GMT0010_EnvelopedData.getInstance(inData);
                byte[] symmkeycipher = GMT0010_RecipientInfo.getInstance(gmt0010EnvelopedData.getRecipientInfos().getObjectAt(0)).getEncryptedKey().getOctets();
                return symmkeycipher;
            }
            catch (Exception e1) {
                return null;
            }
        }
    }

    public static byte[] singleDecryptData(SofInstance sof, byte[] tmpinData) {
        byte[] datacipher;
        SingleDecryptDataReq singleDecryptDataReq = null;
        try {
            EnvelopedData envelopedData = EnvelopedData.getInstance((Object)tmpinData);
            byte[] symmkeycipher = KeyTransRecipientInfo.getInstance((Object)envelopedData.getRecipientInfos().getObjectAt(0)).getEncryptedKey().getOctets();
            datacipher = envelopedData.getEncryptedContentInfo().getEncryptedContent().getOctets();
            ASN1OctetString iv = (ASN1OctetString)envelopedData.getEncryptedContentInfo().getContentEncryptionAlgorithm().getParameters();
            singleDecryptDataReq = new SingleDecryptDataReq(sof.getKeyIndex(), sof.getEncMethod(), symmkeycipher, datacipher, iv);
        }
        catch (Exception e) {
            try {
                GMT0010_EnvelopedData gmt0010EnvelopedData = GMT0010_EnvelopedData.getInstance(tmpinData);
                datacipher = gmt0010EnvelopedData.getEncryptedContentInfo().getEncryptedcontent().getOctets();
                byte[] symmkeycipher = GMT0010_RecipientInfo.getInstance(gmt0010EnvelopedData.getRecipientInfos().getObjectAt(0)).getEncryptedKey().getOctets();
                ASN1OctetString iv = (ASN1OctetString)gmt0010EnvelopedData.getEncryptedContentInfo().getContentType().getParameters();
                singleDecryptDataReq = new SingleDecryptDataReq(sof.getKeyIndex(), sof.getEncMethod(), symmkeycipher, datacipher, iv);
            }
            catch (Exception e1) {
                sof.setErrCode(errorCode.SOR_PKCS7ENCODEErr);
                return null;
            }
        }
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.DECRYPT_DATA_REQ.value(), singleDecryptDataReq);
        try {
            ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "SOF_decryptData", svsRequest.getEncoded());
            if (sequence == null) {
                return null;
            }
            SingleDecryptDataResp singleDecryptDataResp = new SingleDecryptDataResp(sequence.getObjectAt(2));
            long sdkErr = err.singleDecryptoErr(singleDecryptDataResp.getRespValue().getValue().longValue());
            if (sdkErr != (long)errorCode.SOR_OK) {
                sof.setErrCode(sdkErr);
                return null;
            }
            return singleDecryptDataResp.getPlainData().getBytes();
        }
        catch (IOException e) {
            sof.setErrCode(errorCode.SOR_ObjErr);
            return null;
        }
        catch (Exception e) {
            sof.setErrCode(errorCode.SOR_ProviderTypeErr);
            return null;
        }
    }

    public static MultiDecryptDataInitResp multiDecryptDataInit(SofInstance sof, byte[] encKey, byte[] iv) throws Exception {
        DecryptDataApi decryptDataApi = new DecryptDataApi();
        MultiDecryptDataInitResp multiDecryptDataInitResp = decryptDataApi.multipleDecryptDataInit(sof, encKey, iv);
        if (multiDecryptDataInitResp.getRespValue().getValue().longValue() != (long)errorCode.SOR_OK) {
            return null;
        }
        return multiDecryptDataInitResp;
    }

    public static MultiDecryptDataUpdateResp multiDecryptDataUpdate(SofInstance sof, long symKeyID, byte[] ciphertext, byte[] iv) throws Exception {
        DecryptDataApi decryptDataApi = new DecryptDataApi();
        MultiDecryptDataUpdateResp multiDecryptDataUpdateResp = decryptDataApi.multipleDecryptDataUpdateResp(sof, symKeyID, ciphertext, iv);
        if (multiDecryptDataUpdateResp.getRespValue().getValue().longValue() != (long)errorCode.SOR_OK) {
            return null;
        }
        return multiDecryptDataUpdateResp;
    }

    public static MultiDecryptDataFinalResp multiDecryptDataFinal(SofInstance sof, long symKeyID) throws Exception {
        DecryptDataApi decryptDataApi = new DecryptDataApi();
        MultiDecryptDataFinalResp multiDecryptDataFinalResp = decryptDataApi.multipleDecryptDataFinalResp(sof, symKeyID);
        if (multiDecryptDataFinalResp.getRespValue().getValue().longValue() != (long)errorCode.SOR_OK) {
            return null;
        }
        return multiDecryptDataFinalResp;
    }

    public static byte[] multiDecryptData(SofInstance sof, byte[] inData) {
        MapBuilder builder = MapUtil.builder();
        Map map = builder.build();
        try {
            EnvelopedData envelopedData = EnvelopedData.getInstance((Object)inData);
            map.put("symmKey", KeyTransRecipientInfo.getInstance((Object)envelopedData.getRecipientInfos().getObjectAt(0)).getEncryptedKey().getOctets());
            map.put("dataCip", envelopedData.getEncryptedContentInfo().getEncryptedContent().getOctets());
            map.put("iv", envelopedData.getEncryptedContentInfo().getContentEncryptionAlgorithm().getParameters().toASN1Primitive().getEncoded());
        }
        catch (Exception e) {
            try {
                GMT0010_EnvelopedData gmt0010EnvelopedData = GMT0010_EnvelopedData.getInstance(inData);
                map.put("symmKey", gmt0010EnvelopedData.getEncryptedContentInfo().getEncryptedcontent().getOctets());
                map.put("dataCip", GMT0010_RecipientInfo.getInstance(gmt0010EnvelopedData.getRecipientInfos().getObjectAt(0)).getEncryptedKey().getOctets());
                map.put("iv", gmt0010EnvelopedData.getEncryptedContentInfo().getContentType().getParameters().toASN1Primitive().getEncoded());
            }
            catch (Exception e1) {
                sof.setErrCode(errorCode.SOR_PKCS7ENCODEErr);
                return null;
            }
        }
        try {
            MultiDecryptDataInitResp multiDecryptDataInitResp = EncryptDecryptUtils.multiDecryptDataInit(sof, (byte[])map.get("symmKey"), (byte[])map.get("iv"));
            long symKeyID = multiDecryptDataInitResp.getSymKeyID().getValue().longValue();
            byte[] dataCips = (byte[])map.get("dataCip");
            byte[][] split = ArrayUtil.split((byte[])dataCips, (int)4096);
            int length = dataCips.length % 4096;
            int dataNum = split.length;
            byte[] inDataTmp = new byte[length];
            MapBuilder builderUpdata = MapUtil.builder();
            Map mapUpdata = builderUpdata.build();
            MultiDecryptDataUpdateResp multiDecryptDataUpdateResp = null;
            for (int i = 0; i < dataNum; ++i) {
                if (i == dataNum) {
                    System.arraycopy(split[dataNum], 0, inDataTmp, 0, length);
                    multiDecryptDataUpdateResp = EncryptDecryptUtils.multiDecryptDataUpdate(sof, symKeyID, inDataTmp, multiDecryptDataUpdateResp.getIv().getOctets());
                } else {
                    multiDecryptDataUpdateResp = i == 0 ? EncryptDecryptUtils.multiDecryptDataUpdate(sof, symKeyID, split[i], (byte[])map.get("iv")) : EncryptDecryptUtils.multiDecryptDataUpdate(sof, symKeyID, split[i], multiDecryptDataUpdateResp.getIv().getOctets());
                }
                mapUpdata.put(i, multiDecryptDataUpdateResp.getPlaintext().getOctets());
            }
            MultiDecryptDataFinalResp multiDecryptDataFinalResp = EncryptDecryptUtils.multiDecryptDataFinal(sof, symKeyID);
            if (err.singleEncryptoErr(multiDecryptDataFinalResp.getRespValue().getValue().longValue()) != (long)errorCode.SOR_OK) {
                return null;
            }
            byte[] origin = new byte[dataCips.length];
            for (int j = 0; j < mapUpdata.size(); ++j) {
                if (j == mapUpdata.size()) {
                    System.arraycopy(mapUpdata.get(j), 0, origin, 4096 * j, ((byte[])mapUpdata.get(j)).length);
                    continue;
                }
                System.arraycopy(mapUpdata.get(j), 0, origin, 4096 * j, 4096);
            }
            return origin;
        }
        catch (Exception e) {
            sof.setErrCode(errorCode.SOR_ENCRYPTDATAErr);
            return null;
        }
    }

    public static boolean fileEncrypted(SofInstance sof, String inFile, String outFile, X509Certificate x509Certificate) {
        try {
            MultiEncryptDataInitResp multiEncryptDataInitResp = EncryptDecryptUtils.multiEncryptDataInit(sof, x509Certificate);
            long symKeyID = multiEncryptDataInitResp.getSymKeyID().getValue().longValue();
            ASN1OctetString iv = multiEncryptDataInitResp.getIv();
            int i = 0;
            byte[] bys = new byte[4096];
            MultiEncryptDataUpdateResp multiEncryptDataUpdateResp = null;
            MultiEncryptDataFinalResp multiEncryptDataFinalResp = null;
            int len = 0;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(inFile));
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outFile));
            while ((len = bis.read(bys)) != -1) {
                if (i == 0) {
                    multiEncryptDataUpdateResp = EncryptDecryptUtils.multiEncryptDataUpdate(sof, symKeyID, bys, iv);
                    bos.write(multiEncryptDataUpdateResp.getCipherText().getOctets(), 0, len);
                } else {
                    if (len != 4096) {
                        byte[] tmpIndata = new byte[len];
                        ArrayUtil.copy((Object)bys, (Object)tmpIndata, (int)len);
                        multiEncryptDataFinalResp = EncryptDecryptUtils.multiEncryptDataFinal(sof, symKeyID, tmpIndata, multiEncryptDataUpdateResp.getIv());
                        bos.write(multiEncryptDataFinalResp.getCipherText().getOctets(), 0, len);
                        break;
                    }
                    multiEncryptDataUpdateResp = EncryptDecryptUtils.multiEncryptDataUpdate(sof, symKeyID, bys, multiEncryptDataUpdateResp.getIv());
                    bos.write(multiEncryptDataUpdateResp.getCipherText().getOctets(), 0, len);
                }
                ++i;
            }
            bos.close();
            bis.close();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean fileDecrypted(SofInstance sof, String inFile, String outFile) {
        return true;
    }
}

