/*
 * Decompiled with CFR 0.152.
 */
package utils;

import common.ApiMethodId;
import common.ConvertPublicKeyFrombyte;
import common.SofInstance;
import common.SvsOidEnum;
import encapsulation.GMT0010_SignedData;
import encapsulation.GMT0010_SignerInfo;
import execption.errorCode;
import execption.serverErrCode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.util.encoders.Base64;
import protocol.SvsRequest;
import protocol.request.SignDataFinalReq;
import protocol.request.SignDataInitReq;
import protocol.request.SignDataReq;
import protocol.request.SignDataUpdateReq;
import protocol.request.SignMessageInitReq;
import protocol.request.SignMessageReq;
import protocol.request.SignMessageUpdateReq;
import protocol.request.VerifySignDataFinalReq;
import protocol.request.VerifySignDataInitReq;
import protocol.request.VerifySignDataUpdateReq;
import protocol.request.VerifySignedDataReq;
import protocol.request.VerifySignedMessageFinalReq;
import protocol.request.VerifySignedMessageInitReq;
import protocol.request.VerifySignedMessageUpdateReq;
import protocol.response.SignDataFinalResp;
import protocol.response.SignDataInitResp;
import protocol.response.SignDataResp;
import protocol.response.SignDataUpdateResp;
import protocol.response.SignMessageFinalResp;
import protocol.response.SignMessageInitResp;
import protocol.response.SignMessageResp;
import protocol.response.SignMessageUpdateResp;
import protocol.response.VerifySignDataFinalResp;
import protocol.response.VerifySignDataInitResp;
import protocol.response.VerifySignDataUpdateResp;
import protocol.response.VerifySignedDataResp;
import protocol.response.VerifySignedMessageFinalResp;
import socket.SocketFactory;
import utils.Base64Utils;

public class SignedVerifyUtils {
    private long converServerErrToLocalSignMessage(int localErr) {
        if ((long)localErr == serverErrCode.getGmInvalidArgument()) {
            return errorCode.SOR_AlgoTypeErr;
        }
        if ((long)localErr == serverErrCode.getGmInvalidKeyIndex()) {
            return errorCode.SOR_ProviderTypeErr;
        }
        if ((long)localErr == serverErrCode.getGmErrorHostIp()) {
            return errorCode.SOR_NotSupportYetErr;
        }
        if ((long)localErr == serverErrCode.getGmInvalidDataFormat()) {
            return errorCode.SOR_PKCS7ENCODEErr;
        }
        if ((long)localErr == serverErrCode.getGmSystemFailure()) {
            return errorCode.SOR_SIGNDATAErr;
        }
        return 0L;
    }

    private int signMessageServerErr(SofInstance sof, int localerr) {
        if (localerr == 0) {
            return errorCode.SOR_OK;
        }
        long error = this.converServerErrToLocalSignMessage(localerr);
        if (error == 0L) {
            sof.setErrCode(errorCode.SOR_SIGNDATAErr);
            return errorCode.SOR_SIGNDATAErr;
        }
        sof.setErrCode(error);
        return (int)error;
    }

    private long converServerErrToLocal(int localerr) {
        if ((long)localerr == serverErrCode.getGmInvalidArgument()) {
            return errorCode.SOR_PARAMETERNOTSUPPORTErr;
        }
        if ((long)localerr == serverErrCode.getGmErrorHostIp()) {
            return errorCode.SOR_NotSupportYetErr;
        }
        if ((long)localerr == serverErrCode.getGmErrorCompareHash()) {
            return errorCode.SOR_HashNotEqualErr;
        }
        if ((long)localerr == serverErrCode.getGmErrorCertInvalidBf()) {
            return errorCode.SOR_CERTINVALIDErr;
        }
        if ((long)localerr == serverErrCode.getGmErrorCertInvalidAf()) {
            return errorCode.SOR_CERTHASEXPIREDErr;
        }
        if ((long)localerr == serverErrCode.getGmErrorCert()) {
            return errorCode.SOR_CERTINVALIDErr;
        }
        if ((long)localerr == serverErrCode.getGmErrorCertRemoved()) {
            return errorCode.SOR_CERTREVOKEDErr;
        }
        return 0L;
    }

    private int signInterfaceServerError(SofInstance sof, int localerr) {
        if (localerr == 0) {
            return errorCode.SOR_OK;
        }
        long error = this.converServerErrToLocal(localerr);
        if (error == 0L) {
            sof.setErrCode(errorCode.SOR_SIGNDATAErr);
            return errorCode.SOR_SIGNDATAErr;
        }
        sof.setErrCode(error);
        return (int)error;
    }

    private int verifyInterfaceServerError(SofInstance sof, int localerr) {
        if (localerr == 0) {
            return errorCode.SOR_OK;
        }
        long error = this.converServerErrToLocal(localerr);
        if (error == 0L) {
            sof.setErrCode(errorCode.SOR_VERIFYSIGNDATAErr);
            return errorCode.SOR_VERIFYSIGNDATAErr;
        }
        sof.setErrCode(error);
        return (int)error;
    }

    private int checkSignMethod(SofInstance sof) {
        X509Certificate x509Certificate = sof.getSignCert();
        long signMethod = sof.getSignMethod();
        if (x509Certificate == null) {
            sof.setErrCode(errorCode.SOR_CertNotFountErr);
            return errorCode.SOR_CertNotFountErr;
        }
        if (x509Certificate.getPublicKey().getAlgorithm().equals("RSA")) {
            if (signMethod != SvsOidEnum.SM3_RSA && signMethod != SvsOidEnum.SHA1_RSA && signMethod != SvsOidEnum.SHA256_RSA) {
                sof.setErrCode(errorCode.SOR_AlgoTypeErr);
                return errorCode.SOR_AlgoTypeErr;
            }
        } else if (x509Certificate.getPublicKey().getAlgorithm().equals("EC")) {
            if (sof.getSignMethod() != SvsOidEnum.SM3_SM2) {
                sof.setErrCode(errorCode.SOR_AlgoTypeErr);
                return errorCode.SOR_AlgoTypeErr;
            }
        } else {
            sof.setErrCode(errorCode.SOR_CertNotFountErr);
            return errorCode.SOR_CertNotFountErr;
        }
        return errorCode.SOR_OK;
    }

    private X509Certificate checkCert(SofInstance sof, String base64EncodeCert) {
        X509Certificate x509Certificate = ConvertPublicKeyFrombyte.readCertificateFromCerByte(Base64.decode((String)base64EncodeCert));
        if (x509Certificate == null) {
            sof.setErrCode(errorCode.SOR_CERTENCODEErr);
            return null;
        }
        if (x509Certificate.getPublicKey().getAlgorithm().equals("RSA")) {
            long signAlg = sof.getSignMethod();
            if (signAlg != SvsOidEnum.SM3_RSA && signAlg != SvsOidEnum.SHA1_RSA && signAlg != SvsOidEnum.SHA256_RSA) {
                sof.setErrCode(errorCode.SOR_AlgoTypeErr);
                return null;
            }
        } else if (x509Certificate.getPublicKey().getAlgorithm().equals("EC") && sof.getSignMethod() != SvsOidEnum.SM3_SM2) {
            sof.setErrCode(errorCode.SOR_AlgoTypeErr);
            return null;
        }
        return x509Certificate;
    }

    public byte[] signedData(SofInstance sof, byte[] inData) throws Exception {
        SignDataReq signDataReq = new SignDataReq(sof.getSignMethod(), sof.getKeyIndex(), sof.getKeyValue(), inData);
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.SIGN_DATA.value(), signDataReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "SignData_Init", svsRequest.getEncoded());
        if (sequence == null) {
            return null;
        }
        SignDataResp signDataResp = new SignDataResp(sequence.getObjectAt(2));
        if (signDataResp.getRespValue().getValue().intValue() != 0) {
            return null;
        }
        return signDataResp.getSignature().getOctets();
    }

    public boolean verifySignedData(SofInstance sof, String base64EncodeCert, String inData, String signature) throws Exception {
        X509Certificate x509Certificate = this.checkCert(sof, base64EncodeCert);
        if (x509Certificate == null) {
            sof.setErrCode(errorCode.SOR_CERTENCODEErr);
            return false;
        }
        VerifySignedDataReq verifySignedDataReq = new VerifySignedDataReq(1, x509Certificate, x509Certificate.getSerialNumber().toString(), inData.getBytes(StandardCharsets.UTF_8), signature.getBytes(StandardCharsets.UTF_8), sof.getVerifylevel());
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.VERIFY_SIGNED_DATA.value(), verifySignedDataReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "verifySignedData", svsRequest.getEncoded());
        if (sequence == null) {
            return false;
        }
        VerifySignedDataResp verifySignedDataResp = new VerifySignedDataResp(sequence.getObjectAt(2));
        if (verifySignedDataResp.getRespValue().getValue().intValue() != 0) {
            sof.setErrCode(errorCode.SOR_VERIFYSIGNDATAErr);
            return false;
        }
        return true;
    }

    public int signedDataInit(SofInstance sof, byte[] inData) throws Exception {
        if (this.checkSignMethod(sof) != errorCode.SOR_OK) {
            return errorCode.SOR_SIGNDATAErr;
        }
        SignDataInitReq signDataInitReq = new SignDataInitReq(sof.getSignMethod(), sof.getSignCert().getPublicKey().getEncoded(), sof.getSignID().length(), sof.getSignID(), 0, "");
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.SIGN_DATA_INIT.value(), signDataInitReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "SignData_Init", svsRequest.getEncoded());
        if (sequence == null) {
            return errorCode.SOR_SIGNDATAErr;
        }
        SignDataInitResp signDataInitResp = new SignDataInitResp(sequence.getObjectAt(2));
        return this.signInterfaceServerError(sof, signDataInitResp.getRespValue().getValue().intValue());
    }

    public int signedDataUpdate(SofInstance sof, byte[] inData, int inDatalen, byte[] hash) throws Exception {
        SignDataUpdateReq signDataUpdateReq = new SignDataUpdateReq(sof.getSignMethod(), hash.length, hash, inDatalen, inData);
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.SIGN_DATA_UPDATE.value(), signDataUpdateReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "SignData_Update", svsRequest.getEncoded());
        if (sequence == null) {
            return errorCode.SOR_SIGNDATAErr;
        }
        SignDataUpdateResp signDataUpdateResp = new SignDataUpdateResp(sequence.getObjectAt(2));
        return this.signInterfaceServerError(sof, signDataUpdateResp.getRespValue().getValue().intValue());
    }

    public byte[] signedDataFinal(SofInstance sof, byte[] hash) throws Exception {
        String hash_str = new String(hash);
        SignDataFinalReq signDataFinalReq = new SignDataFinalReq(sof.getSignMethod(), sof.getKeyIndex(), sof.getKeyValue(), hash.length, hash);
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.SIGN_DATA_FINAL.value(), signDataFinalReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "SignData_Final", svsRequest.getEncoded());
        if (sequence == null) {
            return null;
        }
        SignDataFinalResp signDataFinalResp = new SignDataFinalResp(sequence.getObjectAt(2));
        int resp = this.signInterfaceServerError(sof, signDataFinalResp.getRespValue().getValue().intValue());
        if (resp == errorCode.SOR_OK) {
            return signDataFinalResp.getSignature().getOctets();
        }
        return null;
    }

    public int verifysignedDataInit(SofInstance sof, String base64EncodeCert) throws Exception {
        X509Certificate x509Certificate = this.checkCert(sof, base64EncodeCert);
        if (x509Certificate == null) {
            sof.setErrCode(errorCode.SOR_CERTENCODEErr);
            return errorCode.SOR_CERTENCODEErr;
        }
        VerifySignDataInitReq verifySignDataInitReq = new VerifySignDataInitReq(sof.getSignMethod(), x509Certificate.getPublicKey().getEncoded(), sof.getSignID().length(), sof.getSignID(), 0, "");
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.VERIFY_SIGNED_DATA_INIT.value(), verifySignDataInitReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "SOF_Verify_Init", svsRequest.getEncoded());
        if (sequence == null) {
            return errorCode.SOR_VERIFYSIGNDATAErr;
        }
        VerifySignDataInitResp verifySignDataInitResp = new VerifySignDataInitResp(sequence.getObjectAt(2));
        return this.verifyInterfaceServerError(sof, verifySignDataInitResp.getRespValue().getValue().intValue());
    }

    public int verifySignedDataUpdate(SofInstance sof, byte[] inDataTmp, int inDataTmplen, byte[] hash) throws Exception {
        VerifySignDataUpdateReq verifySignDataUpdateReq = new VerifySignDataUpdateReq(sof.getSignMethod(), hash.length, hash, inDataTmplen, inDataTmp);
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.VERIFY_SIGNED_DATA_UPDATE.value(), verifySignDataUpdateReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "SignData_Final", svsRequest.getEncoded());
        if (sequence == null) {
            return errorCode.SOR_VERIFYSIGNDATAErr;
        }
        VerifySignDataUpdateResp verifySignDataUpdateResp = new VerifySignDataUpdateResp(sequence.getObjectAt(2));
        return this.verifyInterfaceServerError(sof, verifySignDataUpdateResp.getRespValue().getValue().intValue());
    }

    public boolean verifysignedDataFinal(SofInstance sof, String Base64EncodeCert, String inData, String signature) throws Exception {
        String certSN = "";
        X509Certificate x509Certificate = ConvertPublicKeyFrombyte.readCertificateFromCerByte(Base64.decode((String)Base64EncodeCert));
        if (x509Certificate == null) {
            sof.setErrCode(errorCode.SOR_CERTENCODEErr);
            return false;
        }
        VerifySignDataFinalReq verifySignDataFinalReq = new VerifySignDataFinalReq(sof.getSignMethod(), 1, x509Certificate, certSN, inData.length(), inData, Base64.decode((String)signature), sof.getVerifylevel());
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.VERIFY_SIGNED_DATA_FINAL.value(), verifySignDataFinalReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "VerifysignData_Final_Interface", svsRequest.getEncoded());
        if (sequence == null) {
            return false;
        }
        VerifySignDataFinalResp verifySignDataFinalResp = new VerifySignDataFinalResp(sequence.getObjectAt(2));
        return this.verifyInterfaceServerError(sof, verifySignDataFinalResp.getRespValue().getValue().intValue()) == errorCode.SOR_OK;
    }

    public int signedMessageInit(SofInstance sof, byte[] inData) throws Exception {
        if (this.checkSignMethod(sof) != errorCode.SOR_OK) {
            return errorCode.SOR_SIGNDATAErr;
        }
        SignMessageInitReq signMessageInitReq = new SignMessageInitReq(sof.getSignMethod(), sof.getSignCert().getPublicKey().getEncoded(), sof.getSignID().length(), sof.getSignID(), 0, "");
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.SIGN_MESSAGE_INIT.value(), signMessageInitReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "SignedMessage_Init", svsRequest.getEncoded());
        if (sequence == null) {
            return errorCode.SOR_SIGNDATAErr;
        }
        SignMessageInitResp signMessageInitResp = new SignMessageInitResp(sequence.getObjectAt(2));
        return this.signInterfaceServerError(sof, signMessageInitResp.getRespValue().getValue().intValue());
    }

    public int signedMessageUpdate(SofInstance sof, byte[] inData, int inDatalen, byte[] hash) throws Exception {
        SignMessageUpdateReq signMessageUpdateReq = new SignMessageUpdateReq(sof.getSignMethod(), hash.length, hash, inDatalen, inData);
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.SIGN_MESSAGE_UPDATE.value(), signMessageUpdateReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "SignedMessage_Update", svsRequest.getEncoded());
        if (sequence == null) {
            return errorCode.SOR_SIGNDATAErr;
        }
        SignMessageUpdateResp signMessageUpdateResp = new SignMessageUpdateResp(sequence.getObjectAt(2));
        return this.signInterfaceServerError(sof, signMessageUpdateResp.getRespValue().getValue().intValue());
    }

    public byte[] signedMessageFinal(SofInstance sof, byte[] hash) throws Exception {
        SignDataFinalReq signDataFinalReq = new SignDataFinalReq(sof.getSignMethod(), sof.getKeyIndex(), sof.getKeyValue(), hash.length, hash);
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.SIGN_MESSAGE_FINAL.value(), signDataFinalReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "SignedMessage_Final", svsRequest.getEncoded());
        if (sequence == null) {
            return null;
        }
        SignMessageFinalResp signMessageFinalResp = new SignMessageFinalResp(sequence.getObjectAt(2));
        if (this.signInterfaceServerError(sof, signMessageFinalResp.getRespValue().getValue().intValue()) == errorCode.SOR_OK) {
            return signMessageFinalResp.getSignature().getOctets();
        }
        return null;
    }

    public int verifysignedMessageInit(SofInstance sof, String base64EncodeCert) throws Exception {
        X509Certificate x509Certificate = this.checkCert(sof, base64EncodeCert);
        if (x509Certificate == null) {
            sof.setErrCode(errorCode.SOR_CERTENCODEErr);
            return errorCode.SOR_CERTENCODEErr;
        }
        VerifySignedMessageInitReq verifySignedMessageInitReq = new VerifySignedMessageInitReq(sof.getSignMethod(), x509Certificate.getPublicKey().getEncoded(), sof.getSignID().length(), sof.getSignID(), 0, "");
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.VERIFY_SIGNED_MESSAGE_INIT.value(), verifySignedMessageInitReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "VerifysignedMessage_init", svsRequest.getEncoded());
        if (sequence == null) {
            return errorCode.SOR_VERIFYSIGNDATAErr;
        }
        VerifySignDataInitResp verifySignDataInitResp = new VerifySignDataInitResp(sequence.getObjectAt(2));
        return this.verifyInterfaceServerError(sof, verifySignDataInitResp.getRespValue().getValue().intValue());
    }

    public int verifysignedMessageUpdate(SofInstance sof, byte[] inDataTmp, int inDataTmplen, byte[] hash) throws Exception {
        VerifySignedMessageUpdateReq verifySignedMessageUpdateReq = new VerifySignedMessageUpdateReq(sof.getSignMethod(), hash.length, hash, inDataTmplen, inDataTmp);
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.VERIFY_SIGNED_MESSAGE_UPDATE.value(), verifySignedMessageUpdateReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "VerifysignedMessage_Update", svsRequest.getEncoded());
        if (sequence == null) {
            return errorCode.SOR_VERIFYSIGNDATAErr;
        }
        VerifySignDataUpdateResp verifySignDataUpdateResp = new VerifySignDataUpdateResp(sequence.getObjectAt(2));
        return this.verifyInterfaceServerError(sof, verifySignDataUpdateResp.getRespValue().getValue().intValue());
    }

    public boolean verifysignedMessageFinal(SofInstance sof, String base64EncodeCert, byte[] inData, byte[] signature) throws Exception {
        X509Certificate x509Certificate = this.checkCert(sof, base64EncodeCert);
        if (x509Certificate == null) {
            sof.setErrCode(errorCode.SOR_CERTENCODEErr);
            return false;
        }
        VerifySignedMessageFinalReq verifySignedMessageFinalReq = new VerifySignedMessageFinalReq(sof.getSignMethod(), 1, x509Certificate, x509Certificate.getSerialNumber().toString(), inData.length, inData, signature, sof.getVerifylevel());
        SvsRequest svsRequest = new SvsRequest(ApiMethodId.VERIFY_SIGNED_MESSAGE_FINAL.value(), verifySignedMessageFinalReq);
        ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "VerifysignedMessage_Final", svsRequest.getEncoded());
        if (sequence == null) {
            return false;
        }
        VerifySignedMessageFinalResp verifySignedMessageFinalResp = new VerifySignedMessageFinalResp(sequence.getObjectAt(2));
        return this.verifyInterfaceServerError(sof, verifySignedMessageFinalResp.getRespValue().getValue().intValue()) == errorCode.SOR_OK;
    }

    public byte[] signedDataMulti(SofInstance sof, byte[] inData) throws Exception {
        if (this.signedDataInit(sof, inData) != errorCode.SOR_OK) {
            return null;
        }
        byte[] hash = new byte[32];
        int inDataLen = inData.length;
        byte[] inDataTmp = new byte[]{};
        Integer i = 0;
        while (true) {
            if (inDataLen >= 4096) {
                inDataTmp = new byte[4096];
                System.arraycopy(inData, i * 4096, inDataTmp, 0, 4096);
            } else {
                inDataTmp = new byte[inDataLen];
                System.arraycopy(inData, i * 4096, inDataTmp, 0, inDataLen);
            }
            if (this.signedDataUpdate(sof, inDataTmp, inDataLen, hash) != errorCode.SOR_OK) {
                return null;
            }
            if (inDataLen <= 4096) break;
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            inDataLen -= 4096;
            Arrays.fill(inDataTmp, (byte)0);
        }
        byte[] signValue = this.signedDataFinal(sof, hash);
        if (signValue == null) {
            sof.setErrCode(errorCode.SOR_SIGNDATAErr);
            return null;
        }
        return signValue;
    }

    public boolean verifySignedDataMulti(SofInstance sof, String Base64EncodeCert, String inData, String signature) throws Exception {
        byte[] hash = new byte[32];
        if (this.verifysignedDataInit(sof, Base64EncodeCert) != errorCode.SOR_OK) {
            return false;
        }
        int inDataLen = inData.getBytes().length;
        byte[] inDataTmp = new byte[]{0};
        Integer i = 0;
        while (true) {
            if (inDataLen >= 4096) {
                inDataTmp = new byte[4096];
                System.arraycopy(inData.getBytes(), i * 4096, inDataTmp, 0, 4096);
            } else {
                inDataTmp = new byte[inDataLen];
                System.arraycopy(inData.getBytes(), i * 4096, inDataTmp, 0, inDataLen);
            }
            if (this.verifySignedDataUpdate(sof, inDataTmp, inDataTmp.length, hash) != errorCode.SOR_OK) {
                return false;
            }
            if (inDataLen <= 4096) break;
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            inDataLen -= 4096;
            Arrays.fill(inDataTmp, (byte)0);
        }
        return this.verifysignedDataFinal(sof, Base64EncodeCert, inData, signature);
    }

    public String signMessage(SofInstance sof, byte[] inData) {
        try {
            SignMessageReq signMessageReq = new SignMessageReq(sof.getSignMethod(), sof.getKeyIndex(), sof.getKeyValue(), inData.length, inData, sof.isHashFlag(), true, true, false, false);
            SvsRequest svsRequest = new SvsRequest(ApiMethodId.SIGN_MESSAGE.value(), signMessageReq);
            ASN1Sequence sequence = SocketFactory.sendAndreceiveBody(sof, "SOF_SignMessage", svsRequest.getEncoded());
            if (sequence == null) {
                return null;
            }
            SignMessageResp signMessageResp = new SignMessageResp(sequence.getObjectAt(2));
            if (this.signMessageServerErr(sof, signMessageResp.getRespValue().getValue().intValue()) != errorCode.SOR_OK) {
                return null;
            }
            if (signMessageResp.getSignedMessage() == null) {
                sof.setErrCode(errorCode.SOR_SIGNDATAErr);
                return null;
            }
            return Base64.toBase64String((byte[])signMessageResp.getSignedMessage().getOctets());
        }
        catch (IOException e) {
            sof.setErrCode(errorCode.SOR_ObjErr);
            return null;
        }
        catch (Exception e) {
            sof.setErrCode(errorCode.SOR_SIGNDATAErr);
            return null;
        }
    }

    public byte[] signedMessageDetch(SofInstance sof, byte[] inData) throws Exception {
        byte[] hash = new byte[32];
        if (this.signedMessageInit(sof, inData) != errorCode.SOR_OK) {
            return null;
        }
        int inDataLen = inData.length;
        byte[] inDataTmp = new byte[]{};
        Integer i = 0;
        while (true) {
            if (inDataLen >= 4096) {
                inDataTmp = new byte[4096];
                System.arraycopy(inData, i * 4096, inDataTmp, 0, 4096);
            } else {
                inDataTmp = new byte[inDataLen];
                System.arraycopy(inData, i * 4096, inDataTmp, 0, inDataLen);
            }
            if (this.signedMessageUpdate(sof, inDataTmp, inDataLen, hash) != errorCode.SOR_OK) {
                return null;
            }
            if (inDataLen <= 4096) break;
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            inDataLen -= 4096;
            Arrays.fill(inDataTmp, (byte)0);
        }
        byte[] signValue = this.signedMessageFinal(sof, hash);
        if (signValue == null) {
            return null;
        }
        return signValue;
    }

    public boolean verifySignedMessageDetch(SofInstance sof, byte[] inData, byte[] signature) throws Exception {
        String encodeCert = this.getCertfromSignedMessageDetch(signature);
        if (encodeCert == null) {
            sof.setErrCode(errorCode.SOR_PKCS7ENCODEErr);
            return false;
        }
        byte[] hash = new byte[32];
        if (this.verifysignedMessageInit(sof, encodeCert) != errorCode.SOR_OK) {
            return false;
        }
        int inDataLen = inData.length;
        byte[] inDataTmp = new byte[]{0};
        Integer i = 0;
        while (true) {
            if (inDataLen >= 4096) {
                inDataTmp = new byte[4096];
                System.arraycopy(inData, i * 4096, inDataTmp, 0, 4096);
            } else {
                inDataTmp = new byte[inDataLen];
                System.arraycopy(inData, i * 4096, inDataTmp, 0, inDataLen);
            }
            if (this.verifysignedMessageUpdate(sof, inDataTmp, inDataTmp.length, hash) != errorCode.SOR_OK) {
                return false;
            }
            if (inDataLen <= 4096) break;
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            inDataLen -= 4096;
            Arrays.fill(inDataTmp, (byte)0);
        }
        return this.verifysignedMessageFinal(sof, encodeCert, inData, signature);
    }

    private String getCertfromSignedMessageDetch(byte[] signMessage) {
        try {
            ContentInfo contentInfo = ContentInfo.getInstance((Object)signMessage);
            ASN1Encodable realSignMsg = contentInfo.getContent();
            SignedData signedData = SignedData.getInstance((Object)realSignMsg);
            return Base64Utils.encode(signedData.getCertificates().getObjectAt(0).toASN1Primitive().getEncoded());
        }
        catch (Exception e) {
            try {
                ContentInfo contentInfo = ContentInfo.getInstance((Object)signMessage);
                ASN1Encodable realSignMsg = contentInfo.getContent();
                GMT0010_SignedData gmt0010SignedData = GMT0010_SignedData.getInstance(realSignMsg);
                return Base64Utils.encode(gmt0010SignedData.getCertificates().getObjectAt(0).toASN1Primitive().getEncoded());
            }
            catch (Exception e1) {
                return null;
            }
        }
    }

    private byte[] getSignMethodfromSignedMessageDetch(byte[] signMessage) {
        try {
            SignedData signedData = SignedData.getInstance((Object)signMessage);
            AlgorithmIdentifier digestAlgorithm = SignerInfo.getInstance((Object)signedData.getSignerInfos()).getDigestAlgorithm();
            SignerInfo.getInstance((Object)signedData.getSignerInfos()).getDigestEncryptionAlgorithm();
            return signedData.getCertificates().getObjectAt(0).toASN1Primitive().getEncoded();
        }
        catch (Exception e) {
            try {
                GMT0010_SignedData gmt0010SignedData = GMT0010_SignedData.getInstance(signMessage);
                GMT0010_SignerInfo.getInstance(gmt0010SignedData.getSignedInfos());
                return gmt0010SignedData.getCertificates().getObjectAt(0).toASN1Primitive().getEncoded();
            }
            catch (Exception e1) {
                return null;
            }
        }
    }
}

