/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA1DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA256DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import common.SofInstance;
import common.SvsOidEnum;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import utils.Base64Utils;

public class XMLSignedVerifyUtils {
    private static Element setcanonicalizationMethod(Element signedInfo) {
        Element canonicalizationMethod = signedInfo.addElement("CanonicalizationMethod");
        canonicalizationMethod.addAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        return canonicalizationMethod;
    }

    private static Element setsignatureMethod(Element signedInfo, long signMethod) {
        Element signatureMethod = signedInfo.addElement("SignatureMethod");
        if (signMethod == SvsOidEnum.SM3_SM2) {
            signatureMethod.addAttribute("Algorithm", "http://127.0.0.1/2001/04/xmldsig-more#sm2-sm3");
        } else if (signMethod == SvsOidEnum.SM3_RSA) {
            signatureMethod.addAttribute("Algorithm", "http://127.0.0.1/2001/04/xmldsig-more#rsa-sm3");
        } else if (signMethod == SvsOidEnum.SHA1_RSA) {
            signatureMethod.addAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        } else if (signMethod == SvsOidEnum.SHA256_RSA) {
            signatureMethod.addAttribute("Algorithm", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        }
        return signatureMethod;
    }

    private static Element setreference(Element signedInfo, String originXML, long signMethod) throws Exception {
        Element reference = signedInfo.addElement("Reference");
        reference.addAttribute("URI", "");
        Element transforms = reference.addElement("Transforms");
        Element transforms1 = transforms.addElement("Transform");
        transforms1.addAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        Element digestMethod = reference.addElement("DigestMethod");
        Element digestValue = reference.addElement("DigestValue");
        if (signMethod == SvsOidEnum.SM3_SM2 || signMethod == SvsOidEnum.SM3_RSA) {
            digestMethod.addAttribute("Algorithm", "http://127.0.0.1/2001/04/xmldsig-more#sm3");
            byte[] digest = GMSSLSM3DigestUtils.digest((byte[])originXML.getBytes(StandardCharsets.UTF_8));
            digestValue.addText(Base64Utils.encode(digest));
        } else if (signMethod == SvsOidEnum.SHA1_RSA) {
            digestMethod.addAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
            byte[] digest = GMSSLSHA1DigestUtils.digest((byte[])originXML.getBytes(StandardCharsets.UTF_8));
            digestValue.addText(Base64Utils.encode(digest));
        } else if (signMethod == SvsOidEnum.SHA256_RSA) {
            digestMethod.addAttribute("Algorithm", "http://www.w3.org/2001/04/xmlenc#sha256");
            byte[] digest = GMSSLSHA256DigestUtils.digest((byte[])originXML.getBytes(StandardCharsets.UTF_8));
            digestValue.addText(Base64Utils.encode(digest));
        }
        return reference;
    }

    private static Element setsignValue(Element signature, String signValue) {
        Element signatureValue = signature.addElement("SignatureValue");
        signatureValue.addText(signValue);
        return signatureValue;
    }

    private static Element setkeyInfo(Element signature, X509Certificate x509Certificate) {
        Element keyInfo = signature.addElement("KeyInfo");
        Element keyValue = keyInfo.addElement("KeyValue");
        if (x509Certificate.getPublicKey().getAlgorithm().equals("EC")) {
            Element eccKeyValue = keyValue.addElement("ECKeyValue");
            Element PublicKey2 = eccKeyValue.addElement("PublicKey");
            PublicKey2.addText(Base64Utils.encode(x509Certificate.getPublicKey().getEncoded()));
        } else {
            Element rsaKeyValue = keyValue.addElement("RSAKeyValue");
            Element modulus = rsaKeyValue.addElement("Modulus");
            modulus.addText(Base64Utils.encode(((RSAPublicKey)x509Certificate.getPublicKey()).getModulus().toByteArray()));
            Element exponent = rsaKeyValue.addElement("Exponent");
            exponent.addText(Base64Utils.encode(((RSAPublicKey)x509Certificate.getPublicKey()).getPublicExponent().toByteArray()));
        }
        return keyInfo;
    }

    private static Element setoriginXML(Element signature, String originXML) {
        Element object = signature.addElement("Object");
        try {
            Document document = DocumentHelper.parseText((String)originXML);
            Element rootElement = document.getRootElement();
            Element copy = rootElement.createCopy();
            object.add(copy);
            return object;
        }
        catch (DocumentException e) {
            return null;
        }
    }

    private static Element packetSignatureElement(long signMethod, Document document, String signValue, X509Certificate x509Certificate, boolean originisNull, String originXML) {
        Element signature = document.addElement("Signature");
        signature.addAttribute("xmlns", "http://www.w3.org/2000/09/xmldsig#");
        Element signedInfo = signature.addElement("SignedInfo");
        XMLSignedVerifyUtils.setcanonicalizationMethod(signedInfo);
        XMLSignedVerifyUtils.setsignatureMethod(signedInfo, signMethod);
        try {
            XMLSignedVerifyUtils.setreference(signedInfo, originXML, signMethod);
        }
        catch (Exception e) {
            return null;
        }
        XMLSignedVerifyUtils.setsignValue(signature, signValue);
        XMLSignedVerifyUtils.setkeyInfo(signature, x509Certificate);
        if (!originisNull) {
            XMLSignedVerifyUtils.setoriginXML(signature, originXML);
        }
        return signature;
    }

    private static String packetXMLEnveloping(X509Certificate x509Certificate, String originXML, long signMethod, String signValue) {
        try {
            Document document = DocumentHelper.parseText((String)originXML);
            Element rootElement = document.getRootElement();
            Document documentnew = DocumentHelper.createDocument();
            Element signature = XMLSignedVerifyUtils.packetSignatureElement(signMethod, documentnew, signValue, x509Certificate, true, originXML);
            rootElement.add(signature);
            return document.asXML();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String packetXMLEnveloped(X509Certificate x509Certificate, String originXML, long signMethod, String signValue) {
        Document document = DocumentHelper.createDocument();
        XMLSignedVerifyUtils.packetSignatureElement(signMethod, document, signValue, x509Certificate, false, originXML);
        return document.asXML();
    }

    private static String packetXMLDetached(X509Certificate x509Certificate, String originXML, long signMethod, String signValue) {
        Document document = DocumentHelper.createDocument();
        XMLSignedVerifyUtils.packetSignatureElement(signMethod, document, signValue, x509Certificate, true, originXML);
        return document.asXML();
    }

    public static String signedXML(SofInstance sof, String origin, String signature) {
        String signValue = null;
        switch (sof.getXMLType()) {
            case 0: {
                signValue = XMLSignedVerifyUtils.packetXMLEnveloping(sof.getSignCert(), origin, sof.getSignMethod(), signature);
                break;
            }
            case 1: {
                signValue = XMLSignedVerifyUtils.packetXMLEnveloped(sof.getSignCert(), origin, sof.getSignMethod(), signature);
                break;
            }
            case 2: {
                signValue = XMLSignedVerifyUtils.packetXMLDetached(sof.getSignCert(), origin, sof.getSignMethod(), signature);
                break;
            }
            default: {
                return null;
            }
        }
        if (signValue.equals(null)) {
            return null;
        }
        return signValue;
    }

    public boolean verifyXML() {
        return true;
    }

    public String parseXML() {
        return null;
    }
}

