/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.netone.unixx.unira.sdk;

import cn.com.syan.jcee.common.base.http.HttpException;
import cn.com.syan.jcee.common.base.http.XHttpClientV2;
import cn.com.syan.jcee.common.base.http.XHttpPoolingHttpClientConnectionManager;
import cn.com.syan.jcee.common.base.http.XHttpRequest;
import cn.com.syan.jcee.common.base.http.XHttpRequestPost;
import cn.com.syan.jcee.common.base.http.XHttpResponse;
import cn.com.syan.netone.unixx.unira.sdk.exception.UniraClientException;
import cn.com.syan.netone.unixx.unira.sdk.util.NonceGenerator;
import cn.com.syan.netone.unixx.unira.sdk.util.PKCS7Wrapper;
import com.google.gson.Gson;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spongycastle.jce.provider.BouncyCastleProvider;

public class UniraClientOnline {
    public final String GET_ACTION = "/crt/get";
    public final String REVOKE_ACTION = "/crt/revoke";
    public final String FREEZE_ACTION = "/crt/freeze";
    public final String UNFREEZE_ACTION = "/crt/unfreeze";
    public final String RENEW_ACTION = "/crt/renew";
    public final String GET_RA_ACTION = "/ra/get";
    public final String LIST_RA_ACTION = "/ra/list";
    public final String CLIENT_ADD_ACTION = "/client/add";
    public final String CLIENT_GET_ACTION = "/client/get";
    public final String CLIENT_UPDATE_ACTION = "/client/update";
    public final String CLIENT_APPROVE_ACTION = "/client/approve";
    public final String CLIENT_REWIND_ACTION = "/client/rewind";
    public final String CLIENT_REJECT_ACTION = "/client/reject";
    public final String CLIENT_ISSUE_GENCSR_ACTION = "/client/issue/gencsr";
    public final String CLIENT_ISSUE_INSTALL_ACTION = "/client/issue/install";
    public final String SUCCESS = "200";
    private String baseUrl;
    private PKCS7Wrapper pkcs7Wrapper = null;
    private String requestMessage;

    public UniraClientOnline(String baseUrl, String certValue, String privateKey) throws UniraClientException {
        this();
        this.baseUrl = baseUrl;
        this.pkcs7Wrapper = new PKCS7Wrapper(certValue, privateKey);
    }

    public UniraClientOnline(String baseUrl, X509Certificate cert, PrivateKey privateKey) throws UniraClientException {
        this();
        this.baseUrl = baseUrl;
        this.pkcs7Wrapper = new PKCS7Wrapper(cert, privateKey);
    }

    private UniraClientOnline() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public String messagePack(Map paraMap) throws UniraClientException {
        if (paraMap == null) {
            throw new NullPointerException("\u53c2\u6570\u4e3a\u7a7a");
        }
        paraMap.put("version", 1);
        paraMap.put("nonce", this.genNonce());
        paraMap.put("reqtime", this.genReqTime());
        Gson gson = new Gson();
        String jsonString = gson.toJson((Object)paraMap);
        return this.pkcs7Wrapper.pkcs7Pack(jsonString);
    }

    public Map messageOpen(String data) throws UniraClientException {
        String jsonResponse = this.pkcs7Wrapper.pkcs7Unpack(data);
        Gson gson = new Gson();
        return this.filterDouble((Map)gson.fromJson(jsonResponse, Map.class));
    }

    public Map sendRecv(String action, Map paraMap) throws UniraClientException {
        String requestNonce;
        HashMap requestMap = paraMap;
        if (paraMap == null) {
            requestMap = new HashMap();
        }
        this.requestMessage = this.messagePack(requestMap);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("pkcs7", this.requestMessage.getBytes());
        XHttpRequestPost requestPost = new XHttpRequestPost(this.rebuildRequestUrl(action));
        requestPost.setParameters(params);
        XHttpClientV2 httpClient = new XHttpClientV2(XHttpPoolingHttpClientConnectionManager.getCloseableHttpClient());
        XHttpResponse response = null;
        try {
            response = httpClient.execute((XHttpRequest)requestPost);
            if (response.isFailed()) {
                throw new UniraClientException("\u8bf7\u6c42\u670d\u52a1\u7aef\u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801:" + response.getErrorCode());
            }
            response.getStringResponse();
        }
        catch (HttpException e) {
            throw new UniraClientException(e.getMessage(), e);
        }
        String raResponse = response.getStringResponse();
        if (raResponse == null) {
            throw new UniraClientException("RA\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a.");
        }
        Map raResponseMap = this.messageOpen(raResponse);
        String responseNonce = raResponseMap.get("nonce").toString();
        if (!responseNonce.equals(requestNonce = requestMap.get("nonce").toString())) {
            throw new UniraClientException("\u8bf7\u6c42\u4e0e\u54cd\u5e94\u7684nonce\u503c\u4e0d\u4e00\u81f4." + requestNonce + " VS " + responseNonce);
        }
        return raResponseMap;
    }

    private String rebuildRequestUrl(String action) {
        return this.baseUrl + "/online/api" + action + "?format=json";
    }

    private String genNonce() {
        return NonceGenerator.genNonce();
    }

    private String genReqTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return df.format(new Date());
    }

    private Map filterDouble(Map map) {
        Set keySet = map.keySet();
        for (Object aKeySet : keySet) {
            String key = (String)aKeySet;
            Object value = map.get(key);
            if (value instanceof Double) {
                map.put(key, ((Double)value).intValue());
                continue;
            }
            if (value instanceof Map) {
                this.filterDouble((Map)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            List list = (List)value;
            for (Object aList : list) {
                Object item = aList;
                if (!(item instanceof Map)) continue;
                this.filterDouble((Map)item);
            }
            map.put(key, list);
        }
        return map;
    }

    public String getRequestMessage() {
        return this.requestMessage;
    }
}

