/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.netone.unixx.unira.sdk;

import cn.com.syan.netone.unixx.unira.sdk.UniraClientOnline;
import cn.com.syan.netone.unixx.unira.sdk.UniraResponse;
import cn.com.syan.netone.unixx.unira.sdk.UniraResponseClient;
import cn.com.syan.netone.unixx.unira.sdk.UniraResponseCrt;
import cn.com.syan.netone.unixx.unira.sdk.UniraResponseGencsr;
import cn.com.syan.netone.unixx.unira.sdk.exception.UniraClientException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UniraClientOnlineClient
extends UniraClientOnline {
    public UniraClientOnlineClient(String baseUrl, String certValue, String privateKey) throws UniraClientException {
        super(baseUrl, certValue, privateKey);
    }

    public UniraResponseClient add(String tplId, List<Map> data) throws UniraClientException {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        HashMap<String, List<Map>> itemMap = new HashMap<String, List<Map>>();
        itemMap.put("item", data);
        paraMap.put("templateid", tplId);
        paraMap.put("entityset", itemMap);
        Map responseMap = this.sendRecv("/client/add", paraMap);
        return new UniraResponseClient(responseMap);
    }

    public UniraResponseClient getById(String clientId) throws UniraClientException {
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("clientid", clientId);
        Map responseMap = this.sendRecv("/client/get", paraMap);
        return new UniraResponseClient(responseMap);
    }

    public UniraResponseClient getByCert(String clientCert) throws UniraClientException {
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("clientcert", clientCert);
        Map responseMap = this.sendRecv("/client/get", paraMap);
        return new UniraResponseClient(responseMap);
    }

    public UniraResponseClient update(String clientId, List<Map> data) throws UniraClientException {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        HashMap<String, List<Map>> itemMap = new HashMap<String, List<Map>>();
        itemMap.put("item", data);
        paraMap.put("clientid", clientId);
        paraMap.put("entityset", itemMap);
        Map responseMap = this.sendRecv("/client/update", paraMap);
        return new UniraResponseClient(responseMap);
    }

    public UniraResponse approve(String clientId) throws UniraClientException {
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("clientid", clientId);
        Map responseMap = this.sendRecv("/client/approve", paraMap);
        return new UniraResponse(responseMap);
    }

    public UniraResponse rewind(String clientId) throws UniraClientException {
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("clientid", clientId);
        Map responseMap = this.sendRecv("/client/rewind", paraMap);
        return new UniraResponse(responseMap);
    }

    public UniraResponse reject(String clientId) throws UniraClientException {
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("clientid", clientId);
        Map responseMap = this.sendRecv("/client/reject", paraMap);
        return new UniraResponse(responseMap);
    }

    public UniraResponseGencsr issueGencsr(String clientId, String api) throws UniraClientException {
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("clientid", clientId);
        requestMap.put("api", api);
        Map gencsrMap = this.sendRecv("/client/issue/gencsr", requestMap);
        return new UniraResponseGencsr(gencsrMap);
    }

    private Map issueAjaxParseRequest(HttpServletRequest request) {
        Map requestMap = request.getParameterMap();
        HashMap<String, String> ajaxMap = new HashMap<String, String>();
        Set keySet = requestMap.keySet();
        for (String key : keySet) {
            Object value = requestMap.get(key);
            if (value instanceof String[]) {
                String[] items = (String[])value;
                if (items.length == 1) {
                    ajaxMap.put(key, items[0]);
                    continue;
                }
                ajaxMap.put(key, (String)value);
                continue;
            }
            ajaxMap.put(key, (String)value);
        }
        return ajaxMap;
    }

    public UniraResponseCrt issueAjax(String clientId, String validity, HttpServletRequest request, boolean doubleCert) throws UniraClientException {
        Map requestMap = this.issueAjaxParseRequest(request);
        return this.issueAjax(clientId, validity, requestMap, doubleCert);
    }

    public UniraResponseCrt issueAjax(String clientId, String validity, Map requestMap, boolean doubleCert) throws UniraClientException {
        String api = (String)requestMap.get("api");
        requestMap.put("clientid", clientId);
        requestMap.put("validity", validity);
        requestMap.put("target", api);
        if (doubleCert && this.inArray(api)) {
            HashMap<String, String> escort = new HashMap<String, String>();
            escort.put("escort", "yes");
            requestMap.put(api, escort);
        }
        Map responseMap = this.sendRecv("/client/issue/install", requestMap);
        return new UniraResponseCrt(responseMap);
    }

    private boolean inArray(String api) {
        return "csp".equals(api) || "skf".equals(api);
    }
}

