/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.netone.unixx.unira.sdk;

import cn.com.syan.netone.unixx.unira.sdk.UniraClientOnline;
import cn.com.syan.netone.unixx.unira.sdk.UniraResponse;
import cn.com.syan.netone.unixx.unira.sdk.UniraResponseCrt;
import cn.com.syan.netone.unixx.unira.sdk.exception.UniraClientException;
import java.util.HashMap;
import java.util.Map;

public class UniraClientOnlineCrt
extends UniraClientOnline {
    public UniraClientOnlineCrt(String baseUrl, String certValue, String privateKey) throws UniraClientException {
        super(baseUrl, certValue, privateKey);
    }

    public UniraResponseCrt getByCN(String cn) throws UniraClientException {
        HashMap<String, String> paraMap = new HashMap<String, String>(1);
        paraMap.put("cn", cn);
        Map responseMap = this.sendRecv("/crt/get", paraMap);
        return new UniraResponseCrt(responseMap);
    }

    public UniraResponseCrt getBySN(String sn, int snType) throws UniraClientException {
        String param = 1 == snType ? "snhex" : (2 == snType ? "sndec" : "sn");
        HashMap<String, String> paraMap = new HashMap<String, String>(1);
        paraMap.put(param, sn.toUpperCase());
        Map responseMap = this.sendRecv("/crt/get", paraMap);
        return new UniraResponseCrt(responseMap);
    }

    public UniraResponse revoke(String crt) throws UniraClientException {
        HashMap<String, String> revokeMap = new HashMap<String, String>();
        revokeMap.put("clientcert", crt);
        return new UniraResponse(this.sendRecv("/crt/revoke", revokeMap));
    }

    public UniraResponse freeze(String crt) throws UniraClientException {
        HashMap<String, String> freezeMap = new HashMap<String, String>();
        freezeMap.put("clientcert", crt);
        return new UniraResponse(this.sendRecv("/crt/freeze", freezeMap));
    }

    public UniraResponse unfreeze(String crt) throws UniraClientException {
        HashMap<String, String> unfreezeMap = new HashMap<String, String>();
        unfreezeMap.put("clientcert", crt);
        return new UniraResponse(this.sendRecv("/crt/unfreeze", unfreezeMap));
    }

    public UniraResponseCrt renew(String crt, String validity) throws UniraClientException {
        HashMap<String, String> renewMap = new HashMap<String, String>();
        renewMap.put("clientcert", crt);
        renewMap.put("validity", validity);
        return new UniraResponseCrt(this.sendRecv("/crt/renew", renewMap));
    }
}

