/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.netone.unixx.unira.sdk;

import cn.com.syan.netone.unixx.unira.sdk.GT;
import cn.com.syan.netone.unixx.unira.sdk.UniraResponseEntity;
import cn.com.syan.netone.unixx.unira.sdk.UniraResponseEntitySelect;
import cn.com.syan.netone.unixx.unira.sdk.UniraResponseEntityText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UniraResponse {
    private Map paraMap;
    protected String version;
    protected String nonce;
    protected String command;
    protected boolean failed;
    protected String errorNo;
    protected List errorMessages;

    public UniraResponse(Map hashMap) {
        this.paraMap = hashMap == null ? new HashMap() : hashMap;
        this.init();
    }

    private void init() {
        if (this.paraMap == null) {
            this.failed = true;
            this.errorMessages = new ArrayList();
            this.errorMessages.add("unknown exception.");
        } else {
            this.version = this.paraMap.get("version").toString();
            this.nonce = (String)this.paraMap.get("nonce");
            this.command = (String)this.paraMap.get("command");
            Map errorMap = (Map)this.paraMap.get("error");
            if (errorMap != null) {
                this.failed = true;
                this.errorNo = String.valueOf(new GT().cast(this.paraMap, "error", "errno"));
                this.errorMessages = (List)new GT().cast(this.paraMap, "error", "item");
            }
        }
    }

    public Map getResponse() {
        return this.paraMap;
    }

    public String getVersion() {
        return this.version;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public List getErrorMessages() {
        return this.errorMessages;
    }

    public String getErrorNo() {
        return this.errorNo;
    }

    public List<UniraResponseEntity> parseEntitySet(List<Map> dataList) {
        if (dataList == null) {
            return null;
        }
        ArrayList<UniraResponseEntity> entityList = new ArrayList<UniraResponseEntity>();
        UniraResponseEntity responseEntity = null;
        for (Map entity : dataList) {
            String type = (String)entity.get("type");
            if (type.equals("text")) {
                responseEntity = new UniraResponseEntityText(entity);
            } else if (type.equals("select")) {
                responseEntity = new UniraResponseEntitySelect(entity);
            }
            entityList.add(responseEntity);
        }
        return entityList;
    }

    public Object getSubItemParameter(Map paraMap, String itemSet, String item) {
        Map itemMap = (Map)paraMap.get(itemSet);
        return itemMap == null ? null : itemMap.get(item);
    }
}

