/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.netone.unixx.unira.sdk;

import cn.com.syan.netone.unixx.unira.sdk.UniraResponse;
import cn.com.syan.netone.unixx.unira.sdk.entity.UniraCertificate;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UniraResponseCrt
extends UniraResponse {
    private Map issueMap = null;
    private String sigCertificate;
    private String encCertificate;
    private String encKey;
    private List<UniraCertificate> uniraCertificateList = new ArrayList<UniraCertificate>();

    public UniraResponseCrt(Map hashMap) {
        super(hashMap);
        if (!this.failed) {
            this.issueMap = (Map)this.getResponse().get("data");
            if (null == this.issueMap) {
                ArrayList items = (ArrayList)this.getResponse().get("item");
                Map item = (Map)items.get(0);
                UniraCertificate uc = new UniraCertificate(item);
                this.uniraCertificateList.add(uc);
                this.issueMap = new HashMap(2);
                this.issueMap.put("certificatea", uc.getSignatureCertificate());
                this.issueMap.put("certificatee", uc.getEncryptionCertificate());
                for (int i = 1; i < items.size(); ++i) {
                    uc = new UniraCertificate((Map)items.get(i));
                    this.uniraCertificateList.add(uc);
                }
            }
            this.init();
        }
    }

    private void init() {
        this.sigCertificate = (String)this.issueMap.get("certificatea");
        this.encCertificate = (String)this.issueMap.get("certificatee");
        this.encKey = (String)this.issueMap.get("ekeyblob");
    }

    public String getSigCertificate() {
        return this.sigCertificate;
    }

    public String getEncCertificate() {
        return this.encCertificate;
    }

    public String getEncKey() {
        return this.encKey;
    }

    public String generateAjaxResponse() {
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        GsonBuilder gb = new GsonBuilder().serializeNulls();
        Gson gson = gb.create();
        if (this.isFailed()) {
            respMap.put("status", 1);
            respMap.put("error", this.getErrorMessages().toString());
            return gson.toJson(respMap);
        }
        respMap.put("certificatea", this.getSigCertificate());
        respMap.put("ekeyblob", this.getEncKey());
        respMap.put("certificatee", this.getEncCertificate());
        return gson.toJson(respMap);
    }

    public List<UniraCertificate> getUniraCertificateList() {
        return this.uniraCertificateList;
    }
}

