/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.netone.unixx.unira.sdk;

import java.util.HashMap;
import java.util.Map;

public class UniraResponseEntity {
    private Map rawMsgMap = null;
    private String type;
    private String label;
    private String name;
    private boolean readonly;
    private String shortName;
    private String value;
    private String hint;
    private boolean optional = false;

    public UniraResponseEntity(Map responseMap) {
        this.rawMsgMap = responseMap == null ? new HashMap() : responseMap;
        this.init();
    }

    private UniraResponseEntity() {
    }

    private void init() {
        this.type = (String)this.rawMsgMap.get("type");
        this.label = (String)this.rawMsgMap.get("label");
        this.name = (String)this.rawMsgMap.get("name");
        this.readonly = "readonly".equals(this.rawMsgMap.get("access"));
        this.shortName = (String)this.rawMsgMap.get("shortname");
        this.value = (String)this.rawMsgMap.get("value");
        this.hint = (String)this.rawMsgMap.get("hint");
        Object optionlaItem = this.rawMsgMap.get("notreq");
        this.optional = optionlaItem != null && "yes".equals(optionlaItem);
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getValue() {
        return this.value;
    }

    public boolean setValue(String value) {
        if (!this.isReadOnly()) {
            this.rawMsgMap.put("value", value);
            this.value = value;
            return true;
        }
        return false;
    }

    public String getHint() {
        return this.hint;
    }

    public Map getRawMsg() {
        return this.rawMsgMap;
    }
}

