/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.netone.unixx.unira.sdk.util;

import java.io.IOException;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERSequence;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.DERTaggedObject;
import org.spongycastle.asn1.DLSequence;
import org.spongycastle.asn1.pkcs.Attribute;
import org.spongycastle.pkcs.PKCS10CertificationRequest;
import org.spongycastle.util.encoders.Base64;

public class CSRParser {
    public static String getSubjectFromRequest(String b64CSR) throws IOException {
        PKCS10CertificationRequest p10 = new PKCS10CertificationRequest(Base64.decode((String)b64CSR));
        return p10.getSubject().toString();
    }

    public static String getDeviceIDFromExtensionRequest(String b64CSR) throws IOException {
        String deviceID = null;
        PKCS10CertificationRequest p10 = new PKCS10CertificationRequest(Base64.decode((String)b64CSR));
        Attribute[] attrs = p10.getAttributes(new ASN1ObjectIdentifier("1.2.840.113549.1.9.14"));
        if (attrs.length == 0) {
            return null;
        }
        for (Attribute attr : attrs) {
            DERSet derSet = (DERSet)attr.getAttrValues();
            for (int i = 0; i < derSet.size(); ++i) {
                DERSequence sequence = (DERSequence)derSet.getObjectAt(i);
                for (int k = 0; k < sequence.size(); ++k) {
                    ASN1ObjectIdentifier identifier;
                    DERSequence seq = (DERSequence)sequence.getObjectAt(k);
                    ASN1Encodable ele = seq.getObjectAt(0);
                    if (!(ele instanceof ASN1ObjectIdentifier) || !(identifier = (ASN1ObjectIdentifier)ele).getId().equals("2.5.29.17")) continue;
                    deviceID = CSRParser.deepSearch(seq.getObjectAt(1));
                    return deviceID;
                }
            }
        }
        return null;
    }

    private static String deepSearch(ASN1Encodable element) throws IOException {
        if (element instanceof DEROctetString) {
            ASN1Sequence deviceIDSequence = (ASN1Sequence)ASN1Sequence.fromByteArray((byte[])((DEROctetString)element).getOctets());
            DERTaggedObject altNameObj = (DERTaggedObject)deviceIDSequence.getObjectAt(0);
            DLSequence altNameSequence = (DLSequence)altNameObj.getObject();
            altNameObj = (DERTaggedObject)altNameSequence.getObjectAt(1);
            DEROctetString altString = (DEROctetString)altNameObj.getObject();
            return new String(altString.getOctets());
        }
        throw new IOException("invalid parameter! element is not DEROctectString!");
    }
}

