/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.netone.unixx.unira.sdk.util;

import cn.com.syan.jcee.common.impl.pkcs7.PKCS7Signature;
import cn.com.syan.jcee.common.impl.utils.CertificateConverter;
import cn.com.syan.jcee.utils.PrivateKeyGenerator;
import cn.com.syan.netone.unixx.unira.sdk.exception.UniraClientException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import org.spongycastle.util.encoders.Base64;

public class PKCS7Wrapper {
    private X509Certificate signCert = null;
    private PrivateKey privateKey = null;
    private static final String separator = System.getProperty("line.separator");
    private static final String PKCS7_HEADER = "-----BEGIN PKCS7-----";
    private static final String PKCS7_END = "-----END PKCS7-----";
    private PKCS7Signature pkcs7Signature;
    private PKCS7Signature verifier = new PKCS7Signature();

    public PKCS7Wrapper(String cert, String prvKey) throws UniraClientException {
        this.init(cert, prvKey);
    }

    public PKCS7Wrapper(X509Certificate cert, PrivateKey prvKey) {
        this.signCert = cert;
        this.privateKey = prvKey;
        try {
            this.pkcs7Signature = new PKCS7Signature();
            this.pkcs7Signature.initSign(this.privateKey);
            this.pkcs7Signature.addSigner(this.signCert);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PKCS7Wrapper() {
    }

    private void init(String cert, String prvKey) throws UniraClientException {
        try {
            this.signCert = CertificateConverter.fromBase64((String)cert);
            this.privateKey = PrivateKeyGenerator.generate((String)prvKey);
            this.pkcs7Signature = new PKCS7Signature();
            this.pkcs7Signature.initSign(this.privateKey);
            this.pkcs7Signature.addSigner(this.signCert);
        }
        catch (InvalidKeySpecException e) {
            throw new UniraClientException("failed to generate private key", e);
        }
        catch (CertificateException e) {
            throw new UniraClientException("failed to construct certificate", e);
        }
    }

    public String pkcs7Pack(String data) throws UniraClientException {
        String pkcs7Data;
        try {
            this.pkcs7Signature.update(data.getBytes("utf-8"));
            pkcs7Data = this.toPkcs7PEM(new String(Base64.encode((byte[])this.pkcs7Signature.sign())));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UniraClientException(e.getMessage(), e);
        }
        return pkcs7Data;
    }

    public String pkcs7Unpack(String data) throws UniraClientException {
        String rawData = this.toPkcs7Raw(data);
        try {
            if (!this.verifier.verify(rawData)) {
                throw new UniraClientException("PKCS7\u5305\u9a8c\u8bc1\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new UniraClientException(e.getMessage(), e);
        }
        return new String(this.verifier.getPrimaryContent());
    }

    private String toPkcs7PEM(String rawPkcs7) {
        StringBuilder builder = new StringBuilder(PKCS7_HEADER);
        builder.append(separator);
        int tag = 64;
        int lines = rawPkcs7.length() / tag;
        for (int i = 0; i < lines; ++i) {
            builder.append(rawPkcs7.substring(i * tag, (i + 1) * tag));
            builder.append(separator);
        }
        if (rawPkcs7.length() != lines * tag) {
            builder.append(rawPkcs7.substring(lines * tag));
            builder.append(separator);
        }
        builder.append(PKCS7_END);
        builder.append(separator);
        return builder.toString();
    }

    private String toPkcs7Raw(String pemPKcs7) {
        return pemPKcs7.replace(PKCS7_HEADER, "").replace(PKCS7_END, "");
    }
}

