/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.key;

import com.xdja.jce.base.cipher.PBE;
import com.xdja.jce.base.common.PasswordConverter;
import com.xdja.jce.base.key.BCPBEKey;
import com.xdja.jce.base.key.BaseSecretKeyFactory;
import com.xdja.jce.base.key.PBKDF1Key;
import com.xdja.jce.base.params.CipherParameters;
import com.xdja.jce.base.params.DESParameters;
import com.xdja.jce.base.params.KeyParameter;
import com.xdja.jce.base.params.ParametersWithIV;
import com.xdja.jce.coding.asn1.ASN1ObjectIdentifier;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;

public class DESPBEKeyFactory
extends BaseSecretKeyFactory {
    private boolean forCipher;
    private int scheme;
    private int digest;
    private int keySize;
    private int ivSize;

    public DESPBEKeyFactory(String algorithm, ASN1ObjectIdentifier oid, boolean forCipher, int scheme, int digest, int keySize, int ivSize) {
        super(algorithm, oid);
        this.forCipher = forCipher;
        this.scheme = scheme;
        this.digest = digest;
        this.keySize = keySize;
        this.ivSize = ivSize;
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PBEKeySpec) {
            PBEKeySpec pbeSpec = (PBEKeySpec)keySpec;
            if (pbeSpec.getSalt() == null) {
                if (this.scheme == 0 || this.scheme == 4) {
                    return new PBKDF1Key(pbeSpec.getPassword(), this.scheme == 0 ? PasswordConverter.ASCII : PasswordConverter.UTF8);
                }
                return new BCPBEKey(this.algName, this.algOid, this.scheme, this.digest, this.keySize, this.ivSize, pbeSpec, null);
            }
            CipherParameters param = this.forCipher ? PBE.Util.makePBEParameters(pbeSpec, this.scheme, this.digest, this.keySize, this.ivSize) : PBE.Util.makePBEMacParameters(pbeSpec, this.scheme, this.digest, this.keySize);
            KeyParameter kParam = param instanceof ParametersWithIV ? (KeyParameter)((ParametersWithIV)param).getParameters() : (KeyParameter)param;
            DESParameters.setOddParity(kParam.getKey());
            return new BCPBEKey(this.algName, this.algOid, this.scheme, this.digest, this.keySize, this.ivSize, pbeSpec, param);
        }
        throw new InvalidKeySpecException("Invalid KeySpec");
    }
}

