/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.x509;

import com.xdja.jce.base.common.JcaJceHelper;
import com.xdja.jce.base.common.XdjaJcaJceHelper;
import com.xdja.jce.base.x509.CertificateFactoryAgent;
import com.xdja.jce.base.x509.PEMUtil;
import com.xdja.jce.base.x509.PKIXCertPath;
import com.xdja.jce.base.x509.X509CRLObject;
import com.xdja.jce.base.x509.X509CertificateObject;
import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1InputStream;
import com.xdja.jce.coding.asn1.ASN1ObjectIdentifier;
import com.xdja.jce.coding.asn1.ASN1Sequence;
import com.xdja.jce.coding.asn1.ASN1Set;
import com.xdja.jce.coding.asn1.ASN1TaggedObject;
import com.xdja.jce.coding.asn1.io.Streams;
import com.xdja.jce.coding.asn1.pkcs.PKCSObjectIdentifiers;
import com.xdja.jce.coding.asn1.pkcs.SignedData;
import com.xdja.jce.coding.asn1.x509.CertificateList;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class X509CertificateFactory
implements CertificateFactoryAgent {
    private final JcaJceHelper bcHelper = new XdjaJcaJceHelper();
    private static final PEMUtil PEM_CERT_PARSER = new PEMUtil("CERTIFICATE");
    private static final PEMUtil PEM_CRL_PARSER = new PEMUtil("CRL");
    private static final PEMUtil PEM_PKCS7_PARSER = new PEMUtil("PKCS7");
    private ASN1Set sData = null;
    private int sDataObjectCount = 0;
    private InputStream currentStream = null;
    private ASN1Set sCrlData = null;
    private int sCrlDataObjectCount = 0;
    private InputStream currentCrlStream = null;

    private Certificate readDERCertificate(ASN1InputStream dIn) throws IOException, CertificateParsingException {
        return this.getCertificate(ASN1Sequence.getInstance((Object)dIn.readObject()));
    }

    private Certificate readPEMCertificate(InputStream in) throws IOException, CertificateParsingException {
        return this.getCertificate(PEM_CERT_PARSER.readPEMObject(in));
    }

    private Certificate getCertificate(ASN1Sequence seq) throws CertificateParsingException {
        if (seq == null) {
            return null;
        }
        if (seq.size() > 1 && seq.getObjectAt(0) instanceof ASN1ObjectIdentifier && seq.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sData = SignedData.getInstance((Object)ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)seq.getObjectAt(1)), (boolean)true)).getCertificates();
            return this.getCertificate();
        }
        return new X509CertificateObject(this.bcHelper, com.xdja.jce.coding.asn1.x509.Certificate.getInstance((Object)seq));
    }

    private Certificate getCertificate() throws CertificateParsingException {
        if (this.sData != null) {
            while (this.sDataObjectCount < this.sData.size()) {
                ASN1Encodable obj;
                if (!((obj = this.sData.getObjectAt(this.sDataObjectCount++)) instanceof ASN1Sequence)) continue;
                return new X509CertificateObject(this.bcHelper, com.xdja.jce.coding.asn1.x509.Certificate.getInstance((Object)obj));
            }
        }
        return null;
    }

    protected CRL createCRL(CertificateList c) throws CRLException {
        return new X509CRLObject(this.bcHelper, c);
    }

    private CRL readPEMCRL(InputStream in) throws IOException, CRLException {
        return this.getCRL(PEM_CRL_PARSER.readPEMObject(in));
    }

    private CRL readDERCRL(ASN1InputStream aIn) throws IOException, CRLException {
        return this.getCRL(ASN1Sequence.getInstance((Object)aIn.readObject()));
    }

    private CRL getCRL(ASN1Sequence seq) throws CRLException {
        if (seq == null) {
            return null;
        }
        if (seq.size() > 1 && seq.getObjectAt(0) instanceof ASN1ObjectIdentifier && seq.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sCrlData = SignedData.getInstance((Object)ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)seq.getObjectAt(1)), (boolean)true)).getCRLs();
            return this.getCRL();
        }
        return this.createCRL(CertificateList.getInstance((Object)seq));
    }

    private CRL getCRL() throws CRLException {
        if (this.sCrlData == null || this.sCrlDataObjectCount >= this.sCrlData.size()) {
            return null;
        }
        return this.createCRL(CertificateList.getInstance((Object)this.sCrlData.getObjectAt(this.sCrlDataObjectCount++)));
    }

    @Override
    public Certificate generateCertificate(InputStream in) throws CertificateException {
        if (this.currentStream == null) {
            this.currentStream = in;
            this.sData = null;
            this.sDataObjectCount = 0;
        } else if (this.currentStream != in) {
            this.currentStream = in;
            this.sData = null;
            this.sDataObjectCount = 0;
        }
        try {
            if (this.sData != null) {
                if (this.sDataObjectCount != this.sData.size()) {
                    return this.getCertificate();
                }
                this.sData = null;
                this.sDataObjectCount = 0;
                return null;
            }
            InputStream pis = in.markSupported() ? in : new ByteArrayInputStream(Streams.readAll((InputStream)in));
            pis.mark(1);
            int tag = pis.read();
            if (tag == -1) {
                return null;
            }
            pis.reset();
            if (tag != 48) {
                return this.readPEMCertificate(pis);
            }
            return this.readDERCertificate(new ASN1InputStream(pis));
        }
        catch (Exception e) {
            throw new ExCertificateException("parsing issue: " + e.getMessage(), e);
        }
    }

    public Collection generateCertificates(InputStream inStream) throws CertificateException {
        Certificate cert;
        BufferedInputStream in = new BufferedInputStream(inStream);
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        while ((cert = this.generateCertificate(in)) != null) {
            certs.add(cert);
        }
        return certs;
    }

    @Override
    public CRL generateCRL(InputStream in) throws CRLException {
        if (this.currentCrlStream == null) {
            this.currentCrlStream = in;
            this.sCrlData = null;
            this.sCrlDataObjectCount = 0;
        } else if (this.currentCrlStream != in) {
            this.currentCrlStream = in;
            this.sCrlData = null;
            this.sCrlDataObjectCount = 0;
        }
        try {
            if (this.sCrlData != null) {
                if (this.sCrlDataObjectCount != this.sCrlData.size()) {
                    return this.getCRL();
                }
                this.sCrlData = null;
                this.sCrlDataObjectCount = 0;
                return null;
            }
            InputStream pis = in.markSupported() ? in : new ByteArrayInputStream(Streams.readAll((InputStream)in));
            pis.mark(1);
            int tag = pis.read();
            if (tag == -1) {
                return null;
            }
            pis.reset();
            if (tag != 48) {
                return this.readPEMCRL(pis);
            }
            return this.readDERCRL(new ASN1InputStream(pis, true));
        }
        catch (CRLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CRLException(e.toString());
        }
    }

    public Collection generateCRLs(InputStream inStream) throws CRLException {
        CRL crl;
        ArrayList<CRL> crls = new ArrayList<CRL>();
        BufferedInputStream in = new BufferedInputStream(inStream);
        while ((crl = this.generateCRL(in)) != null) {
            crls.add(crl);
        }
        return crls;
    }

    public Iterator engineGetCertPathEncodings() {
        return PKIXCertPath.certPathEncodings.iterator();
    }

    public CertPath engineGenerateCertPath(InputStream inStream) throws CertificateException {
        return this.engineGenerateCertPath(inStream, "PkiPath");
    }

    public CertPath engineGenerateCertPath(InputStream inStream, String encoding) throws CertificateException {
        return new PKIXCertPath(inStream, encoding);
    }

    public CertPath engineGenerateCertPath(List certificates) throws CertificateException {
        for (Object obj : certificates) {
            if (obj == null || obj instanceof X509Certificate) continue;
            throw new CertificateException("list contains non X509Certificate object while creating CertPath\n" + obj.toString());
        }
        return new PKIXCertPath(certificates);
    }

    private class ExCertificateException
    extends CertificateException {
        private Throwable cause;

        public ExCertificateException(Throwable cause) {
            this.cause = cause;
        }

        public ExCertificateException(String msg, Throwable cause) {
            super(msg);
            this.cause = cause;
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }
    }
}

