/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.x9;

import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1EncodableVector;
import com.xdja.jce.coding.asn1.ASN1Integer;
import com.xdja.jce.coding.asn1.ASN1Object;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.ASN1Sequence;
import com.xdja.jce.coding.asn1.ASN1TaggedObject;
import com.xdja.jce.coding.asn1.DERBitString;
import com.xdja.jce.coding.asn1.DERSequence;

public class DHValidationParms
extends ASN1Object {
    private DERBitString seed;
    private ASN1Integer pgenCounter;

    public static DHValidationParms getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DHValidationParms.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static DHValidationParms getInstance(Object obj) {
        if (obj instanceof DHValidationParms) {
            return (DHValidationParms)((Object)obj);
        }
        if (obj != null) {
            return new DHValidationParms(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    public DHValidationParms(DERBitString seed, ASN1Integer pgenCounter) {
        if (seed == null) {
            throw new IllegalArgumentException("'seed' cannot be null");
        }
        if (pgenCounter == null) {
            throw new IllegalArgumentException("'pgenCounter' cannot be null");
        }
        this.seed = seed;
        this.pgenCounter = pgenCounter;
    }

    private DHValidationParms(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.seed = DERBitString.getInstance((Object)seq.getObjectAt(0));
        this.pgenCounter = ASN1Integer.getInstance((Object)seq.getObjectAt(1));
    }

    public DERBitString getSeed() {
        return this.seed;
    }

    public ASN1Integer getPgenCounter() {
        return this.pgenCounter;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(2);
        v.add((ASN1Encodable)this.seed);
        v.add((ASN1Encodable)this.pgenCounter);
        return new DERSequence(v);
    }
}

