/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.x9;

import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1EncodableVector;
import com.xdja.jce.coding.asn1.ASN1Object;
import com.xdja.jce.coding.asn1.ASN1ObjectIdentifier;
import com.xdja.jce.coding.asn1.ASN1OctetString;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.ASN1Sequence;
import com.xdja.jce.coding.asn1.DERSequence;
import java.util.Enumeration;

public class KeySpecificInfo
extends ASN1Object {
    private ASN1ObjectIdentifier algorithm;
    private ASN1OctetString counter;

    public KeySpecificInfo(ASN1ObjectIdentifier algorithm, ASN1OctetString counter) {
        this.algorithm = algorithm;
        this.counter = counter;
    }

    public static KeySpecificInfo getInstance(Object obj) {
        if (obj instanceof KeySpecificInfo) {
            return (KeySpecificInfo)((Object)obj);
        }
        if (obj != null) {
            return new KeySpecificInfo(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    private KeySpecificInfo(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.algorithm = (ASN1ObjectIdentifier)e.nextElement();
        this.counter = (ASN1OctetString)e.nextElement();
    }

    public ASN1ObjectIdentifier getAlgorithm() {
        return this.algorithm;
    }

    public ASN1OctetString getCounter() {
        return this.counter;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(2);
        v.add((ASN1Encodable)this.algorithm);
        v.add((ASN1Encodable)this.counter);
        return new DERSequence(v);
    }
}

