/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.cipher.asymmetric;

import com.xdja.jce.base.cipher.AsymmetricCipher;
import com.xdja.jce.base.cipher.asymmetric.DecoratorAsymmetricCipher;
import com.xdja.jce.base.cipher.asymmetric.ECUtils;
import com.xdja.jce.base.cipher.asymmetric.util.ECUtil;
import com.xdja.jce.base.common.CryptoServicesRegistrar;
import com.xdja.jce.base.interfaces.ECKey;
import com.xdja.jce.base.io.ErasableOutputStream;
import com.xdja.jce.base.params.AsymmetricKeyParameter;
import com.xdja.jce.base.params.Mode;
import com.xdja.jce.base.params.ParametersWithMode;
import com.xdja.jce.base.params.ParametersWithRandom;
import com.xdja.jce.base.spec.SM2AlgorithmParameterSpec;
import com.xdja.jce.core.exception.BadBlockException;
import com.xdja.jce.core.provider.DecoratorAlgorithmParameters;
import com.xdja.jce.core.util.Strings;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class GMCipherSpi
extends CipherSpi {
    private AsymmetricCipher engine;
    private int state = -1;
    private ErasableOutputStream buffer = new ErasableOutputStream();
    private AsymmetricKeyParameter key;
    private SecureRandom random;
    private Mode mode;

    public GMCipherSpi(AsymmetricCipher engine) {
        this.engine = engine;
    }

    @Override
    public int engineGetBlockSize() {
        return 0;
    }

    @Override
    public int engineGetKeySize(Key key) {
        if (key instanceof ECKey) {
            return ((ECKey)((Object)key)).getParameters().getCurve().getFieldSize();
        }
        throw new IllegalArgumentException("not an EC key");
    }

    @Override
    public byte[] engineGetIV() {
        return null;
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        if (this.engine instanceof DecoratorAsymmetricCipher) {
            DecoratorAlgorithmParameters parameters = new DecoratorAlgorithmParameters(null, null, null);
            parameters.setDeviceProvider(((DecoratorAsymmetricCipher)this.engine).getDeviceProvider());
            return parameters;
        }
        return null;
    }

    @Override
    public void engineSetMode(String mode) throws NoSuchAlgorithmException {
        String modeName = Strings.toUpperCase((String)mode);
        if (!modeName.equals("NONE")) {
            throw new IllegalArgumentException("can't support mode " + mode);
        }
    }

    @Override
    public int engineGetOutputSize(int inputLen) {
        if (this.state == 1 || this.state == 3) {
            return this.engine.getOutputSize(inputLen);
        }
        if (this.state == 2 || this.state == 4) {
            return this.engine.getOutputSize(inputLen);
        }
        throw new IllegalStateException("cipher not initialised");
    }

    @Override
    public void engineSetPadding(String padding) throws NoSuchPaddingException {
        String paddingName = Strings.toUpperCase((String)padding);
        if (!paddingName.equals("NOPADDING")) {
            throw new NoSuchPaddingException("padding not available with IESCipher");
        }
    }

    @Override
    public void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec paramSpec = null;
        if (params != null) {
            throw new InvalidAlgorithmParameterException("cannot recognise parameters: " + params.getClass().getName());
        }
        this.engineInit(opmode, key, paramSpec, random);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void engineInit(int opmode, Key key, AlgorithmParameterSpec engineSpec, SecureRandom random) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (null != engineSpec && engineSpec instanceof SM2AlgorithmParameterSpec) {
            this.mode = ((SM2AlgorithmParameterSpec)engineSpec).getMode();
        }
        if (opmode == 1 || opmode == 3) {
            if (!(key instanceof PublicKey)) throw new InvalidKeyException("must be passed public EC key for encryption");
            this.key = ECUtils.generatePublicKeyParameter((PublicKey)key);
        } else {
            if (opmode != 2 && opmode != 4) throw new InvalidKeyException("must be passed EC key");
            if (!(key instanceof PrivateKey)) throw new InvalidKeyException("must be passed private EC key for decryption");
            this.key = ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        }
        this.random = random != null ? random : CryptoServicesRegistrar.getSecureRandom();
        this.state = opmode;
        this.buffer.reset();
    }

    @Override
    public void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalArgumentException("cannot handle supplied parameter spec: " + e.getMessage());
        }
    }

    @Override
    public byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        this.buffer.write(input, inputOffset, inputLen);
        return null;
    }

    @Override
    public int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        this.buffer.write(input, inputOffset, inputLen);
        return 0;
    }

    @Override
    public byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        block12: {
            if (inputLen != 0) {
                this.buffer.write(input, inputOffset, inputLen);
            }
            ParametersWithMode parametersWithMode = null;
            if (null != this.mode) {
                parametersWithMode = new ParametersWithMode(this.key, this.mode);
            }
            if (this.state == 1 || this.state == 3) {
                try {
                    this.engine.init(true, null == parametersWithMode ? new ParametersWithRandom(this.key, this.random) : new ParametersWithRandom(parametersWithMode, this.random));
                    byte[] byArray = this.engine.processBlock(this.buffer.getBuf(), 0, this.buffer.size());
                    return byArray;
                }
                catch (Exception e) {
                    throw new BadBlockException("unable to process block", (Throwable)e);
                }
            }
            if (this.state != 2 && this.state != 4) break block12;
            try {
                this.engine.init(false, null == parametersWithMode ? this.key : new ParametersWithMode(this.key, this.mode));
                byte[] e = this.engine.processBlock(this.buffer.getBuf(), 0, this.buffer.size());
                return e;
            }
            catch (Exception e) {
                throw new BadBlockException("unable to process block", (Throwable)e);
            }
        }
        throw new IllegalStateException("cipher not initialised");
        finally {
            this.buffer.erase();
        }
    }

    @Override
    public int engineDoFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] buf = this.engineDoFinal(input, inputOffset, inputLength);
        System.arraycopy(buf, 0, output, outputOffset, buf.length);
        return buf.length;
    }
}

