/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.ec.custom.sec;

import com.xdja.jce.base.ec.AbstractECLookupTable;
import com.xdja.jce.base.ec.ECConstants;
import com.xdja.jce.base.ec.ECCurve;
import com.xdja.jce.base.ec.ECFieldElement;
import com.xdja.jce.base.ec.ECLookupTable;
import com.xdja.jce.base.ec.ECPoint;
import com.xdja.jce.base.ec.custom.sec.SecT131FieldElement;
import com.xdja.jce.base.ec.custom.sec.SecT131R2Point;
import com.xdja.jce.base.raw.Nat192;
import com.xdja.jce.core.util.encoders.Hex;
import java.math.BigInteger;

public class SecT131R2Curve
extends ECCurve.AbstractF2m {
    private static final int SECT131R2_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT131R2_AFFINE_ZS = new ECFieldElement[]{new SecT131FieldElement(ECConstants.ONE)};
    protected SecT131R2Point infinity = new SecT131R2Point(this, null, null);

    public SecT131R2Curve() {
        super(131, 2, 3, 8);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict((String)"03E5A88919D7CAFCBF415F07C2176573B2")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict((String)"04B8266A46C55657AC734CE38F018F2192")));
        this.order = new BigInteger(1, Hex.decodeStrict((String)"0400000000000000016954A233049BA98F"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecT131R2Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getFieldSize() {
        return 131;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecT131FieldElement(x);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y) {
        return new SecT131R2Point(this, x, y);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs) {
        return new SecT131R2Point(this, x, y, zs);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 131;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 3;
    }

    public int getK3() {
        return 8;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int FE_LONGS = 3;
        final long[] table = new long[len * 3 * 2];
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            ECPoint p = points[off + i];
            Nat192.copy64(((SecT131FieldElement)p.getRawXCoord()).x, 0, table, pos);
            Nat192.copy64(((SecT131FieldElement)p.getRawYCoord()).x, 0, table, pos += 3);
            pos += 3;
        }
        return new AbstractECLookupTable(){

            @Override
            public int getSize() {
                return len;
            }

            @Override
            public ECPoint lookup(int index) {
                long[] x = Nat192.create64();
                long[] y = Nat192.create64();
                int pos = 0;
                for (int i = 0; i < len; ++i) {
                    long MASK = (i ^ index) - 1 >> 31;
                    for (int j = 0; j < 3; ++j) {
                        int n = j;
                        x[n] = x[n] ^ table[pos + j] & MASK;
                        int n2 = j;
                        y[n2] = y[n2] ^ table[pos + 3 + j] & MASK;
                    }
                    pos += 6;
                }
                return this.createPoint(x, y);
            }

            @Override
            public ECPoint lookupVar(int index) {
                long[] x = Nat192.create64();
                long[] y = Nat192.create64();
                int pos = index * 3 * 2;
                for (int j = 0; j < 3; ++j) {
                    x[j] = table[pos + j];
                    y[j] = table[pos + 3 + j];
                }
                return this.createPoint(x, y);
            }

            private ECPoint createPoint(long[] x, long[] y) {
                return SecT131R2Curve.this.createRawPoint(new SecT131FieldElement(x), new SecT131FieldElement(y), SECT131R2_AFFINE_ZS);
            }
        };
    }
}

