/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.signers;

import com.xdja.jce.base.cipher.AsymmetricCipher;
import com.xdja.jce.base.encodings.PKCS1Encoding;
import com.xdja.jce.base.params.RSAKeyParameters;
import com.xdja.jce.base.rsa.RSAUtil;
import com.xdja.jce.base.rsa.engine.RSABlindedEngine;
import com.xdja.jce.base.teletrust.TeleTrusTObjectIdentifiers;
import com.xdja.jce.base.util.ArraysUtils;
import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1ObjectIdentifier;
import com.xdja.jce.coding.asn1.DERNull;
import com.xdja.jce.coding.asn1.nist.NISTObjectIdentifiers;
import com.xdja.jce.coding.asn1.oiw.OIWObjectIdentifiers;
import com.xdja.jce.coding.asn1.pkcs.PKCSObjectIdentifiers;
import com.xdja.jce.coding.asn1.x509.AlgorithmIdentifier;
import com.xdja.jce.coding.asn1.x509.DigestInfo;
import com.xdja.jce.core.util.Arrays;
import com.xdja.jce.hash.digest.Digest;
import com.xdja.jce.hash.digest.DigestFactory;
import com.xdja.jce.hash.engine.MD2Digest;
import com.xdja.jce.hash.engine.RIPEMD160Digest;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class DigestSignatureSpi
extends SignatureSpi {
    private Digest digest;
    private AsymmetricCipher cipher;
    private AlgorithmIdentifier algId;

    protected DigestSignatureSpi(Digest digest, AsymmetricCipher cipher) {
        this.digest = digest;
        this.cipher = cipher;
        this.algId = null;
    }

    protected DigestSignatureSpi(ASN1ObjectIdentifier objId, Digest digest, AsymmetricCipher cipher) {
        this.digest = digest;
        this.cipher = cipher;
        this.algId = new AlgorithmIdentifier(objId, (ASN1Encodable)DERNull.INSTANCE);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(publicKey) + ") is not a RSAPublicKey instance");
        }
        RSAKeyParameters param = RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey);
        this.digest.reset();
        this.cipher.init(false, param);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(privateKey) + ") is not a RSAPrivateKey instance");
        }
        RSAKeyParameters param = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey);
        this.digest.reset();
        this.cipher.init(true, param);
    }

    private String getType(Object o) {
        if (o == null) {
            return null;
        }
        return o.getClass().getName();
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            byte[] bytes = this.derEncode(hash);
            return this.cipher.processBlock(bytes, 0, bytes.length);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SignatureException("key too small for signature type", e);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString(), e);
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] sig;
        byte[] expected;
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            expected = this.derEncode(hash);
            ArraysUtils.printHexBinary(null, "expected", expected);
            sig = this.cipher.processBlock(sigBytes, 0, sigBytes.length);
        }
        catch (Exception e) {
            return false;
        }
        if (sig.length == expected.length) {
            return Arrays.constantTimeAreEqual((byte[])sig, (byte[])expected);
        }
        if (sig.length == expected.length - 2) {
            int i;
            expected[1] = (byte)(expected[1] - 2);
            expected[3] = (byte)(expected[3] - 2);
            int sigOffset = 4 + expected[3];
            int expectedOffset = sigOffset + 2;
            int nonEqual = 0;
            for (i = 0; i < expected.length - expectedOffset; ++i) {
                nonEqual |= sig[sigOffset + i] ^ expected[expectedOffset + i];
            }
            for (i = 0; i < sigOffset; ++i) {
                nonEqual |= sig[i] ^ expected[i];
            }
            return nonEqual == 0;
        }
        Arrays.constantTimeAreEqual((byte[])expected, (byte[])expected);
        return false;
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    private byte[] derEncode(byte[] hash) throws IOException {
        if (this.algId == null) {
            return hash;
        }
        DigestInfo dInfo = new DigestInfo(this.algId, hash);
        return dInfo.getEncoded("DER");
    }

    public static class RIPEMD160
    extends DigestSignatureSpi {
        public RIPEMD160() {
            super(TeleTrusTObjectIdentifiers.ripemd160, (Digest)new RIPEMD160Digest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class MD5
    extends DigestSignatureSpi {
        public MD5() {
            super(PKCSObjectIdentifiers.md5, DigestFactory.createMD5(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class MD2
    extends DigestSignatureSpi {
        public MD2() {
            super(PKCSObjectIdentifiers.md2, (Digest)new MD2Digest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA3_512
    extends DigestSignatureSpi {
        public SHA3_512() {
            super(NISTObjectIdentifiers.id_sha3_512, DigestFactory.createSHA3_512(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA3_384
    extends DigestSignatureSpi {
        public SHA3_384() {
            super(NISTObjectIdentifiers.id_sha3_384, DigestFactory.createSHA3_384(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA3_256
    extends DigestSignatureSpi {
        public SHA3_256() {
            super(NISTObjectIdentifiers.id_sha3_256, DigestFactory.createSHA3_256(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA3_224
    extends DigestSignatureSpi {
        public SHA3_224() {
            super(NISTObjectIdentifiers.id_sha3_224, DigestFactory.createSHA3_224(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA512_256
    extends DigestSignatureSpi {
        public SHA512_256() {
            super(NISTObjectIdentifiers.id_sha512_256, DigestFactory.createSHA512_256(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA512_224
    extends DigestSignatureSpi {
        public SHA512_224() {
            super(NISTObjectIdentifiers.id_sha512_224, DigestFactory.createSHA512_224(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA512
    extends DigestSignatureSpi {
        public SHA512() {
            super(NISTObjectIdentifiers.id_sha512, DigestFactory.createSHA512(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA384
    extends DigestSignatureSpi {
        public SHA384() {
            super(NISTObjectIdentifiers.id_sha384, DigestFactory.createSHA384(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA256
    extends DigestSignatureSpi {
        public SHA256() {
            super(NISTObjectIdentifiers.id_sha256, DigestFactory.createSHA256(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA224
    extends DigestSignatureSpi {
        public SHA224() {
            super(NISTObjectIdentifiers.id_sha224, DigestFactory.createSHA224(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA1
    extends DigestSignatureSpi {
        public SHA1() {
            super(OIWObjectIdentifiers.idSHA1, DigestFactory.createSHA1(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }
}

