/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.util;

import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1EncodableVector;
import com.xdja.jce.coding.asn1.ASN1Integer;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.ASN1Sequence;
import com.xdja.jce.coding.asn1.DERSequence;
import com.xdja.jce.core.util.Arrays;
import com.xdja.jce.core.util.BigIntegers;
import com.xdja.jce.logger.Logger;
import com.xdja.jce.logger.LoggerFactory;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Map;

public class ConverUtils {
    private static Logger logger = LoggerFactory.getLogger((String)ConverUtils.class.getName());
    private static int BLOCK_SIZE = 16;

    public static byte[] paddingData(byte[] data, boolean isPkcs) {
        int paddingLength = BLOCK_SIZE - data.length % BLOCK_SIZE;
        byte[] plainText = new byte[data.length + paddingLength];
        System.arraycopy(data, 0, plainText, 0, data.length);
        byte padding = !isPkcs ? (byte)(paddingLength - 1) : (byte)paddingLength;
        int off = data.length;
        for (int i = 0; i < paddingLength; ++i) {
            plainText[off++] = padding;
        }
        return plainText;
    }

    public static byte[] removePadding(byte[] cipher, byte[] plain, boolean isPkcs) {
        byte lastByte = plain[plain.length - 1];
        byte[] plainText = isPkcs ? new byte[cipher.length - (lastByte & 0xFF)] : new byte[cipher.length - ((lastByte & 0xFF) + 1)];
        System.arraycopy(plain, 0, plainText, 0, plainText.length);
        return plainText;
    }

    public static void printEnvProperties() {
        logger.error("ENV============================================");
        Map<String, String> map = System.getenv();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            logger.error(entry.getKey() + "=" + entry.getValue());
        }
        logger.error("Properties============================================");
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            logger.error(entry.getKey() + "=" + entry.getValue());
        }
        logger.info("XDJA GMSSL TOMCAT PLUGIN contextInitialized done!");
    }

    public static byte[] derSignatureEncode(byte[] r, byte[] s) throws IOException {
        return ConverUtils.derSignatureEncode(BigIntegers.fromUnsignedByteArray((byte[])r), BigIntegers.fromUnsignedByteArray((byte[])s));
    }

    public static byte[] derSignatureEncode(BigInteger r, BigInteger s) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        return new DERSequence(v).getEncoded("DER");
    }

    public static BigInteger[] derSignatureDecode(byte[] encoding) throws IOException {
        BigInteger s;
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)ASN1Primitive.fromByteArray((byte[])encoding));
        if (seq.size() != 2) {
            return null;
        }
        BigInteger r = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue();
        byte[] expectedEncoding = ConverUtils.derSignatureEncode(r, s = ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue());
        if (!Arrays.constantTimeAreEqual((byte[])expectedEncoding, (byte[])encoding)) {
            return null;
        }
        return new BigInteger[]{r, s};
    }
}

