/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.util;

import com.xdja.jce.base.ec.CustomNamedCurves;
import com.xdja.jce.base.params.AsymmetricKeyParameter;
import com.xdja.jce.base.params.DHParameters;
import com.xdja.jce.base.params.DHPrivateKeyParameters;
import com.xdja.jce.base.params.DSAParameters;
import com.xdja.jce.base.params.DSAPrivateKeyParameters;
import com.xdja.jce.base.params.ECDomainParameters;
import com.xdja.jce.base.params.ECNamedDomainParameters;
import com.xdja.jce.base.params.ECPrivateKeyParameters;
import com.xdja.jce.base.params.ElGamalParameters;
import com.xdja.jce.base.params.ElGamalPrivateKeyParameters;
import com.xdja.jce.base.params.RSAPrivateCrtKeyParameters;
import com.xdja.jce.base.x9.ECNamedCurveTable;
import com.xdja.jce.base.x9.X962Parameters;
import com.xdja.jce.base.x9.X9ECParameters;
import com.xdja.jce.base.x9.X9ObjectIdentifiers;
import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1InputStream;
import com.xdja.jce.coding.asn1.ASN1Integer;
import com.xdja.jce.coding.asn1.ASN1ObjectIdentifier;
import com.xdja.jce.coding.asn1.ASN1OctetString;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.oiw.ElGamalParameter;
import com.xdja.jce.coding.asn1.oiw.OIWObjectIdentifiers;
import com.xdja.jce.coding.asn1.pkcs.DHParameter;
import com.xdja.jce.coding.asn1.pkcs.PKCSObjectIdentifiers;
import com.xdja.jce.coding.asn1.pkcs.PrivateKeyInfo;
import com.xdja.jce.coding.asn1.pkcs.RSAPrivateKey;
import com.xdja.jce.coding.asn1.sec.ECPrivateKey;
import com.xdja.jce.coding.asn1.x509.AlgorithmIdentifier;
import com.xdja.jce.coding.asn1.x509.DSAParameter;
import com.xdja.jce.coding.asn1.x509.X509ObjectIdentifiers;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] privateKeyInfoData) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])privateKeyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance((Object)new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo keyInfo) throws IOException {
        AlgorithmIdentifier algId = keyInfo.getPrivateKeyAlgorithm();
        ASN1ObjectIdentifier algOID = algId.getAlgorithm();
        if (algOID.equals((ASN1Primitive)PKCSObjectIdentifiers.rsaEncryption) || algOID.equals((ASN1Primitive)PKCSObjectIdentifiers.id_RSASSA_PSS) || algOID.equals((ASN1Primitive)X509ObjectIdentifiers.id_ea_rsa)) {
            RSAPrivateKey keyStructure = RSAPrivateKey.getInstance((Object)keyInfo.parsePrivateKey());
            return new RSAPrivateCrtKeyParameters(keyStructure.getModulus(), keyStructure.getPublicExponent(), keyStructure.getPrivateExponent(), keyStructure.getPrime1(), keyStructure.getPrime2(), keyStructure.getExponent1(), keyStructure.getExponent2(), keyStructure.getCoefficient());
        }
        if (algOID.equals((ASN1Primitive)PKCSObjectIdentifiers.dhKeyAgreement)) {
            DHParameter params = DHParameter.getInstance((Object)algId.getParameters());
            ASN1Integer derX = (ASN1Integer)keyInfo.parsePrivateKey();
            BigInteger lVal = params.getL();
            int l = lVal == null ? 0 : lVal.intValue();
            DHParameters dhParams = new DHParameters(params.getP(), params.getG(), null, l);
            return new DHPrivateKeyParameters(derX.getValue(), dhParams);
        }
        if (algOID.equals((ASN1Primitive)OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter params = ElGamalParameter.getInstance((Object)algId.getParameters());
            ASN1Integer derX = (ASN1Integer)keyInfo.parsePrivateKey();
            return new ElGamalPrivateKeyParameters(derX.getValue(), new ElGamalParameters(params.getP(), params.getG()));
        }
        if (algOID.equals((ASN1Primitive)X9ObjectIdentifiers.id_dsa)) {
            ASN1Integer derX = (ASN1Integer)keyInfo.parsePrivateKey();
            ASN1Encodable algParameters = algId.getParameters();
            DSAParameters parameters = null;
            if (algParameters != null) {
                DSAParameter params = DSAParameter.getInstance((Object)algParameters.toASN1Primitive());
                parameters = new DSAParameters(params.getP(), params.getQ(), params.getG());
            }
            return new DSAPrivateKeyParameters(derX.getValue(), parameters);
        }
        if (algOID.equals((ASN1Primitive)X9ObjectIdentifiers.id_ecPublicKey)) {
            ECDomainParameters dParams;
            X962Parameters params = X962Parameters.getInstance(algId.getParameters());
            if (params.isNamedCurve()) {
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)params.getParameters();
                X9ECParameters x9 = CustomNamedCurves.getByOID(oid);
                if (x9 == null) {
                    x9 = ECNamedCurveTable.getByOID(oid);
                }
                dParams = new ECNamedDomainParameters(oid, x9);
            } else {
                X9ECParameters x9 = X9ECParameters.getInstance(params.getParameters());
                dParams = new ECDomainParameters(x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
            }
            ECPrivateKey ec = ECPrivateKey.getInstance((Object)keyInfo.parsePrivateKey());
            BigInteger d = ec.getKey();
            return new ECPrivateKeyParameters(d, dParams);
        }
        throw new RuntimeException("algorithm identifier in private key not recognised");
    }

    private static byte[] getRawKey(PrivateKeyInfo keyInfo) throws IOException {
        return ASN1OctetString.getInstance((Object)keyInfo.parsePrivateKey()).getOctets();
    }
}

