/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.util;

import com.xdja.jce.base.ec.ECPoint;
import com.xdja.jce.base.ec.FixedPointCombMultiplier;
import com.xdja.jce.base.params.AsymmetricKeyParameter;
import com.xdja.jce.base.params.DSAParameters;
import com.xdja.jce.base.params.DSAPrivateKeyParameters;
import com.xdja.jce.base.params.ECDomainParameters;
import com.xdja.jce.base.params.ECNamedDomainParameters;
import com.xdja.jce.base.params.ECPrivateKeyParameters;
import com.xdja.jce.base.params.RSAKeyParameters;
import com.xdja.jce.base.params.RSAPrivateCrtKeyParameters;
import com.xdja.jce.base.x9.X962Parameters;
import com.xdja.jce.base.x9.X9ECParameters;
import com.xdja.jce.base.x9.X9ECPoint;
import com.xdja.jce.base.x9.X9ObjectIdentifiers;
import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1Integer;
import com.xdja.jce.coding.asn1.ASN1Null;
import com.xdja.jce.coding.asn1.ASN1Set;
import com.xdja.jce.coding.asn1.DERBitString;
import com.xdja.jce.coding.asn1.DERNull;
import com.xdja.jce.coding.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.xdja.jce.coding.asn1.pkcs.PKCSObjectIdentifiers;
import com.xdja.jce.coding.asn1.pkcs.PrivateKeyInfo;
import com.xdja.jce.coding.asn1.pkcs.RSAPrivateKey;
import com.xdja.jce.coding.asn1.sec.ECPrivateKey;
import com.xdja.jce.coding.asn1.x509.AlgorithmIdentifier;
import com.xdja.jce.coding.asn1.x509.DSAParameter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class PrivateKeyInfoFactory {
    private static Set cryptoProOids = new HashSet(5);

    private PrivateKeyInfoFactory() {
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter privateKey) throws IOException {
        return PrivateKeyInfoFactory.createPrivateKeyInfo(privateKey, null);
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter privateKey, ASN1Set attributes) throws IOException {
        if (privateKey instanceof RSAKeyParameters) {
            RSAPrivateCrtKeyParameters priv = (RSAPrivateCrtKeyParameters)privateKey;
            return new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), (ASN1Encodable)new RSAPrivateKey(priv.getModulus(), priv.getPublicExponent(), priv.getExponent(), priv.getP(), priv.getQ(), priv.getDP(), priv.getDQ(), priv.getQInv()), attributes);
        }
        if (privateKey instanceof DSAPrivateKeyParameters) {
            DSAPrivateKeyParameters priv = (DSAPrivateKeyParameters)privateKey;
            DSAParameters params = priv.getParameters();
            return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)new DSAParameter(params.getP(), params.getQ(), params.getG())), (ASN1Encodable)new ASN1Integer(priv.getX()), attributes);
        }
        if (privateKey instanceof ECPrivateKeyParameters) {
            int orderBitLength;
            X962Parameters params;
            ECPrivateKeyParameters priv = (ECPrivateKeyParameters)privateKey;
            ECDomainParameters domainParams = priv.getParameters();
            if (domainParams == null) {
                params = new X962Parameters((ASN1Null)DERNull.INSTANCE);
                orderBitLength = priv.getD().bitLength();
            } else if (domainParams instanceof ECNamedDomainParameters) {
                params = new X962Parameters(((ECNamedDomainParameters)domainParams).getName());
                orderBitLength = domainParams.getN().bitLength();
            } else {
                X9ECParameters ecP = new X9ECParameters(domainParams.getCurve(), new X9ECPoint(domainParams.getG(), false), domainParams.getN(), domainParams.getH(), domainParams.getSeed());
                params = new X962Parameters(ecP);
                orderBitLength = domainParams.getN().bitLength();
            }
            ECPoint q = new FixedPointCombMultiplier().multiply(domainParams.getG(), priv.getD());
            DERBitString publicKey = new DERBitString(q.getEncoded(false));
            return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)params), (ASN1Encodable)new ECPrivateKey(orderBitLength, priv.getD(), publicKey, (ASN1Encodable)params), attributes);
        }
        throw new IOException("key parameters not recognized");
    }

    private static void extractBytes(byte[] encKey, int size, int offSet, BigInteger bI) {
        byte[] val = bI.toByteArray();
        if (val.length < size) {
            byte[] tmp = new byte[size];
            System.arraycopy(val, 0, tmp, tmp.length - val.length, val.length);
            val = tmp;
        }
        for (int i = 0; i != size; ++i) {
            encKey[offSet + i] = val[val.length - 1 - i];
        }
    }

    static {
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_A);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_B);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_C);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchA);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchB);
    }
}

