/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.x509;

import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1EncodableVector;
import com.xdja.jce.coding.asn1.ASN1Integer;
import com.xdja.jce.coding.asn1.ASN1Object;
import com.xdja.jce.coding.asn1.ASN1ObjectIdentifier;
import com.xdja.jce.coding.asn1.ASN1OctetString;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.ASN1Sequence;
import com.xdja.jce.coding.asn1.ASN1TaggedObject;
import com.xdja.jce.coding.asn1.DEROctetString;
import com.xdja.jce.coding.asn1.DERSequence;
import com.xdja.jce.coding.asn1.DERTaggedObject;
import com.xdja.jce.coding.asn1.x509.Extension;
import com.xdja.jce.coding.asn1.x509.Extensions;
import com.xdja.jce.coding.asn1.x509.GeneralNames;
import com.xdja.jce.coding.asn1.x509.SubjectPublicKeyInfo;
import com.xdja.jce.core.util.encoders.Hex;
import com.xdja.jce.hash.engine.SHA1Digest;
import java.math.BigInteger;
import java.util.Enumeration;

public class AuthorityKeyIdentifier
extends ASN1Object {
    ASN1OctetString keyidentifier = null;
    GeneralNames certissuer = null;
    ASN1Integer certserno = null;

    public static AuthorityKeyIdentifier getInstance(ASN1TaggedObject obj, boolean explicit) {
        return AuthorityKeyIdentifier.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static AuthorityKeyIdentifier getInstance(Object obj) {
        if (obj instanceof AuthorityKeyIdentifier) {
            return (AuthorityKeyIdentifier)((Object)obj);
        }
        if (obj != null) {
            return new AuthorityKeyIdentifier(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    public static AuthorityKeyIdentifier fromExtensions(Extensions extensions) {
        return AuthorityKeyIdentifier.getInstance(Extensions.getExtensionParsedValue((Extensions)extensions, (ASN1ObjectIdentifier)Extension.authorityKeyIdentifier));
    }

    protected AuthorityKeyIdentifier(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        block5: while (e.hasMoreElements()) {
            ASN1TaggedObject o = ASN1TaggedObject.getInstance(e.nextElement());
            switch (o.getTagNo()) {
                case 0: {
                    this.keyidentifier = ASN1OctetString.getInstance((ASN1TaggedObject)o, (boolean)false);
                    continue block5;
                }
                case 1: {
                    this.certissuer = GeneralNames.getInstance((ASN1TaggedObject)o, (boolean)false);
                    continue block5;
                }
                case 2: {
                    this.certserno = ASN1Integer.getInstance((ASN1TaggedObject)o, (boolean)false);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("illegal tag");
        }
    }

    public AuthorityKeyIdentifier(SubjectPublicKeyInfo spki) {
        this(spki, null, null);
    }

    public AuthorityKeyIdentifier(SubjectPublicKeyInfo spki, GeneralNames name, BigInteger serialNumber) {
        SHA1Digest digest = new SHA1Digest();
        byte[] resBuf = new byte[digest.getDigestSize()];
        byte[] bytes = spki.getPublicKeyData().getBytes();
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        this.keyidentifier = new DEROctetString(resBuf);
        this.certissuer = name;
        this.certserno = serialNumber != null ? new ASN1Integer(serialNumber) : null;
    }

    public AuthorityKeyIdentifier(GeneralNames name, BigInteger serialNumber) {
        this((byte[])null, name, serialNumber);
    }

    public AuthorityKeyIdentifier(byte[] keyIdentifier) {
        this(keyIdentifier, null, null);
    }

    public AuthorityKeyIdentifier(byte[] keyIdentifier, GeneralNames name, BigInteger serialNumber) {
        this.keyidentifier = keyIdentifier != null ? new DEROctetString(keyIdentifier) : null;
        this.certissuer = name;
        this.certserno = serialNumber != null ? new ASN1Integer(serialNumber) : null;
    }

    public byte[] getKeyIdentifier() {
        if (this.keyidentifier != null) {
            return this.keyidentifier.getOctets();
        }
        return null;
    }

    public GeneralNames getAuthorityCertIssuer() {
        return this.certissuer;
    }

    public BigInteger getAuthorityCertSerialNumber() {
        if (this.certserno != null) {
            return this.certserno.getValue();
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(3);
        if (this.keyidentifier != null) {
            v.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.keyidentifier));
        }
        if (this.certissuer != null) {
            v.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)this.certissuer));
        }
        if (this.certserno != null) {
            v.add((ASN1Encodable)new DERTaggedObject(false, 2, (ASN1Encodable)this.certserno));
        }
        return new DERSequence(v);
    }

    public String toString() {
        String keyID = this.keyidentifier != null ? Hex.toHexString((byte[])this.keyidentifier.getOctets()) : "null";
        return "AuthorityKeyIdentifier: KeyID(" + keyID + ")";
    }
}

