/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.x509;

import com.xdja.jce.base.common.JcaJceHelper;
import com.xdja.jce.base.x509.AnnotatedException;
import com.xdja.jce.base.x509.PKIXCertRevocationChecker;
import com.xdja.jce.base.x509.PKIXCertRevocationCheckerParameters;
import com.xdja.jce.base.x509.RFC3280CertPathUtilities;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class ProvCrlRevocationChecker
implements PKIXCertRevocationChecker {
    private final JcaJceHelper helper;
    private PKIXCertRevocationCheckerParameters params;

    public ProvCrlRevocationChecker(JcaJceHelper helper) {
        this.helper = helper;
    }

    @Override
    public void setParameter(String name, Object value) {
    }

    @Override
    public void initialize(PKIXCertRevocationCheckerParameters params) {
        this.params = params;
    }

    public void init(boolean forForward) throws CertPathValidatorException {
        if (forForward) {
            throw new CertPathValidatorException("forward checking not supported");
        }
    }

    @Override
    public void check(Certificate certificate) throws CertPathValidatorException {
        try {
            RFC3280CertPathUtilities.checkCRLs(this.params, this.params.getParamsPKIX(), (X509Certificate)certificate, this.params.getValidDate(), this.params.getSigningCert(), this.params.getWorkingPublicKey(), this.params.getCertPath().getCertificates(), this.helper);
        }
        catch (AnnotatedException e) {
            Throwable cause = e;
            if (null != e.getCause()) {
                cause = e.getCause();
            }
            throw new CertPathValidatorException(e.getMessage(), cause, this.params.getCertPath(), this.params.getIndex());
        }
    }
}

