/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.coding.asn1;

import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1OutputStream;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.core.util.Encodable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class ASN1Object
implements ASN1Encodable,
Encodable {
    public void encodeTo(OutputStream output) throws IOException {
        ASN1OutputStream.create(output).writeObject(this);
    }

    public void encodeTo(OutputStream output, String encoding) throws IOException {
        ASN1OutputStream.create(output, encoding).writeObject(this);
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encodeTo(bOut);
        return bOut.toByteArray();
    }

    public byte[] getEncoded(String encoding) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encodeTo(bOut, encoding);
        return bOut.toByteArray();
    }

    public int hashCode() {
        return this.toASN1Primitive().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ASN1Encodable)) {
            return false;
        }
        ASN1Encodable other = (ASN1Encodable)o;
        return this.toASN1Primitive().equals(other.toASN1Primitive());
    }

    public ASN1Primitive toASN1Object() {
        return this.toASN1Primitive();
    }

    protected static boolean hasEncodedTagValue(Object obj, int tagValue) {
        return obj instanceof byte[] && ((byte[])obj)[0] == tagValue;
    }

    @Override
    public abstract ASN1Primitive toASN1Primitive();
}

