/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.coding.asn1;

import com.xdja.jce.coding.asn1.ASN1EncodableVector;
import com.xdja.jce.coding.asn1.ASN1External;
import com.xdja.jce.coding.asn1.ASN1Integer;
import com.xdja.jce.coding.asn1.ASN1ObjectIdentifier;
import com.xdja.jce.coding.asn1.ASN1OutputStream;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.DERTaggedObject;
import com.xdja.jce.coding.asn1.DLTaggedObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DLExternal
extends ASN1External {
    public DLExternal(ASN1EncodableVector vector) {
        super(vector);
    }

    public DLExternal(ASN1ObjectIdentifier directReference, ASN1Integer indirectReference, ASN1Primitive dataValueDescriptor, DERTaggedObject externalData) {
        this(directReference, indirectReference, dataValueDescriptor, externalData.getTagNo(), externalData.toASN1Primitive());
    }

    public DLExternal(ASN1ObjectIdentifier directReference, ASN1Integer indirectReference, ASN1Primitive dataValueDescriptor, int encoding, ASN1Primitive externalData) {
        super(directReference, indirectReference, dataValueDescriptor, encoding, externalData);
    }

    @Override
    ASN1Primitive toDLObject() {
        return this;
    }

    @Override
    int encodedLength() throws IOException {
        return this.getEncoded().length;
    }

    @Override
    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.directReference != null) {
            baos.write(this.directReference.getEncoded("DL"));
        }
        if (this.indirectReference != null) {
            baos.write(this.indirectReference.getEncoded("DL"));
        }
        if (this.dataValueDescriptor != null) {
            baos.write(this.dataValueDescriptor.getEncoded("DL"));
        }
        DLTaggedObject obj = new DLTaggedObject(true, this.encoding, this.externalContent);
        baos.write(obj.getEncoded("DL"));
        out.writeEncoded(withTag, 32, 8, baos.toByteArray());
    }
}

