/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.coding.asn1;

import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1EncodableVector;
import com.xdja.jce.coding.asn1.ASN1Exception;
import com.xdja.jce.coding.asn1.ASN1InputStream;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.ASN1TaggedObject;
import com.xdja.jce.coding.asn1.BERApplicationSpecificParser;
import com.xdja.jce.coding.asn1.BERBitStringParser;
import com.xdja.jce.coding.asn1.BEROctetStringParser;
import com.xdja.jce.coding.asn1.BERSequenceParser;
import com.xdja.jce.coding.asn1.BERSetParser;
import com.xdja.jce.coding.asn1.BERTaggedObjectParser;
import com.xdja.jce.coding.asn1.DERExternalParser;
import com.xdja.jce.coding.asn1.DEROctetStringParser;
import com.xdja.jce.coding.asn1.DLApplicationSpecific;
import com.xdja.jce.coding.asn1.DLBitStringParser;
import com.xdja.jce.coding.asn1.DLSequenceParser;
import com.xdja.jce.coding.asn1.DLSetParser;
import com.xdja.jce.coding.asn1.DefiniteLengthInputStream;
import com.xdja.jce.coding.asn1.InMemoryRepresentable;
import com.xdja.jce.coding.asn1.IndefiniteLengthInputStream;
import com.xdja.jce.coding.asn1.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASN1StreamParser {
    private final InputStream _in;
    private final int _limit;
    private final byte[][] tmpBuffers;

    public ASN1StreamParser(InputStream in) {
        this(in, StreamUtil.findLimit(in));
    }

    public ASN1StreamParser(byte[] encoding) {
        this(new ByteArrayInputStream(encoding), encoding.length);
    }

    public ASN1StreamParser(InputStream in, int limit) {
        this(in, limit, new byte[11][]);
    }

    ASN1StreamParser(InputStream in, int limit, byte[][] tmpBuffers) {
        this._in = in;
        this._limit = limit;
        this.tmpBuffers = tmpBuffers;
    }

    ASN1Encodable readIndef(int tagValue) throws IOException {
        switch (tagValue) {
            case 3: {
                return new BERBitStringParser(this);
            }
            case 4: {
                return new BEROctetStringParser(this);
            }
            case 8: {
                return new DERExternalParser(this);
            }
            case 16: {
                return new BERSequenceParser(this);
            }
            case 17: {
                return new BERSetParser(this);
            }
        }
        throw new ASN1Exception("unknown BER object encountered: 0x" + Integer.toHexString(tagValue));
    }

    ASN1Encodable readImplicit(boolean constructed, int tag) throws IOException {
        if (this._in instanceof IndefiniteLengthInputStream) {
            if (!constructed) {
                throw new IOException("indefinite-length primitive encoding encountered");
            }
            return this.readIndef(tag);
        }
        if (constructed) {
            switch (tag) {
                case 3: {
                    return new BERBitStringParser(this);
                }
                case 4: {
                    return new BEROctetStringParser(this);
                }
                case 17: {
                    return new DLSetParser(this);
                }
                case 16: {
                    return new DLSequenceParser(this);
                }
            }
        } else {
            switch (tag) {
                case 3: {
                    return new DLBitStringParser((DefiniteLengthInputStream)this._in);
                }
                case 4: {
                    return new DEROctetStringParser((DefiniteLengthInputStream)this._in);
                }
                case 17: {
                    throw new ASN1Exception("sequences must use constructed encoding (see X.690 8.9.1/8.10.1)");
                }
                case 16: {
                    throw new ASN1Exception("sets must use constructed encoding (see X.690 8.11.1/8.12.1)");
                }
            }
        }
        throw new ASN1Exception("implicit tagging not implemented");
    }

    ASN1Primitive readTaggedObject(int tagClass, int tagNo, boolean constructed) throws IOException {
        if (!constructed) {
            byte[] contentsOctets = ((DefiniteLengthInputStream)this._in).toByteArray();
            return ASN1TaggedObject.createPrimitive(tagClass, tagNo, contentsOctets);
        }
        boolean isIL = this._in instanceof IndefiniteLengthInputStream;
        ASN1EncodableVector contentsElements = this.readVector();
        return ASN1TaggedObject.createConstructed(tagClass, tagNo, isIL, contentsElements);
    }

    public ASN1Encodable readObject() throws IOException {
        int tag = this._in.read();
        if (tag == -1) {
            return null;
        }
        this.set00Check(false);
        int tagNo = ASN1InputStream.readTagNumber(this._in, tag);
        boolean isConstructed = (tag & 0x20) != 0;
        int length = ASN1InputStream.readLength(this._in, this._limit, tagNo == 3 || tagNo == 4 || tagNo == 16 || tagNo == 17 || tagNo == 8);
        if (length < 0) {
            if (!isConstructed) {
                throw new IOException("indefinite-length primitive encoding encountered");
            }
            IndefiniteLengthInputStream indIn = new IndefiniteLengthInputStream(this._in, this._limit);
            ASN1StreamParser sp = new ASN1StreamParser(indIn, this._limit, this.tmpBuffers);
            int tagClass = tag & 0xC0;
            if (0 != tagClass) {
                if (64 == tagClass) {
                    return new BERApplicationSpecificParser(tagNo, true, sp);
                }
                return new BERTaggedObjectParser(tagClass, tagNo, true, sp);
            }
            return sp.readIndef(tagNo);
        }
        DefiniteLengthInputStream defIn = new DefiniteLengthInputStream(this._in, length, this._limit);
        int tagClass = tag & 0xC0;
        if (0 != tagClass) {
            ASN1StreamParser sp = new ASN1StreamParser(defIn, defIn.getLimit(), this.tmpBuffers);
            if (64 == tagClass) {
                return (DLApplicationSpecific)sp.readTaggedObject(tagClass, tagNo, isConstructed);
            }
            return new BERTaggedObjectParser(tagClass, tagNo, isConstructed, sp);
        }
        if (!isConstructed) {
            switch (tagNo) {
                case 3: {
                    return new DLBitStringParser(defIn);
                }
                case 4: {
                    return new DEROctetStringParser(defIn);
                }
            }
            try {
                return ASN1InputStream.createPrimitiveDERObject(tagNo, defIn, this.tmpBuffers);
            }
            catch (IllegalArgumentException e) {
                throw new ASN1Exception("corrupted stream detected", e);
            }
        }
        ASN1StreamParser sp = new ASN1StreamParser(defIn, defIn.getLimit(), this.tmpBuffers);
        switch (tagNo) {
            case 3: {
                return new BERBitStringParser(sp);
            }
            case 4: {
                return new BEROctetStringParser(sp);
            }
            case 16: {
                return new DLSequenceParser(sp);
            }
            case 17: {
                return new DLSetParser(sp);
            }
            case 8: {
                return new DERExternalParser(sp);
            }
        }
        throw new IOException("unknown tag " + tagNo + " encountered");
    }

    private void set00Check(boolean enabled) {
        if (this._in instanceof IndefiniteLengthInputStream) {
            ((IndefiniteLengthInputStream)this._in).setEofOn00(enabled);
        }
    }

    ASN1EncodableVector readVector() throws IOException {
        ASN1Encodable obj = this.readObject();
        if (null == obj) {
            return new ASN1EncodableVector(0);
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        do {
            if (obj instanceof InMemoryRepresentable) {
                v.add(((InMemoryRepresentable)((Object)obj)).getLoadedObject());
                continue;
            }
            v.add(obj.toASN1Primitive());
        } while ((obj = this.readObject()) != null);
        return v;
    }
}

