/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.coding.asn1;

import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1Exception;
import com.xdja.jce.coding.asn1.ASN1Object;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.ASN1Tag;
import com.xdja.jce.coding.asn1.ASN1TaggedObject;
import com.xdja.jce.coding.asn1.ASN1TaggedObjectParser;
import java.io.IOException;

public abstract class ASN1Util {
    public static String getTagText(ASN1Tag tag) {
        return ASN1Util.getTagText(tag.getTagClass(), tag.getTagNumber());
    }

    public static String getTagText(ASN1TaggedObject taggedObject) {
        return ASN1Util.getTagText(taggedObject.getTagClass(), taggedObject.getTagNo());
    }

    public static String getTagText(ASN1TaggedObjectParser taggedObjectParser) {
        return ASN1Util.getTagText(taggedObjectParser.getTagClass(), taggedObjectParser.getTagNo());
    }

    public static String getTagText(int tagClass, int tagNo) {
        switch (tagClass) {
            case 64: {
                return "[APPLICATION " + tagNo + "]";
            }
            case 128: {
                return "[CONTEXT " + tagNo + "]";
            }
            case 192: {
                return "[PRIVATE " + tagNo + "]";
            }
        }
        return "[UNIVERSAL " + tagNo + "]";
    }

    public static ASN1Object getExplicitBaseObject(ASN1TaggedObject taggedObject, int tagClass, int tagNo) {
        if (!taggedObject.hasTag(tagClass, tagNo)) {
            String expected = ASN1Util.getTagText(tagClass, tagNo);
            String found = ASN1Util.getTagText(taggedObject);
            throw new IllegalStateException("Expected " + expected + " tag but found " + found);
        }
        return taggedObject.getExplicitBaseObject();
    }

    public static ASN1Object getExplicitContextBaseObject(ASN1TaggedObject taggedObject, int tagNo) {
        return ASN1Util.getExplicitBaseObject(taggedObject, 128, tagNo);
    }

    public static ASN1Object tryGetExplicitBaseObject(ASN1TaggedObject taggedObject, int tagClass, int tagNo) {
        if (!taggedObject.hasTag(tagClass, tagNo)) {
            return null;
        }
        return taggedObject.getExplicitBaseObject();
    }

    public static ASN1Object tryGetExplicitContextBaseObject(ASN1TaggedObject taggedObject, int tagNo) {
        return ASN1Util.tryGetExplicitBaseObject(taggedObject, 128, tagNo);
    }

    public static ASN1TaggedObject getExplicitBaseTagged(ASN1TaggedObject taggedObject, int tagClass, int tagNo) {
        if (!taggedObject.hasTag(tagClass, tagNo)) {
            String expected = ASN1Util.getTagText(tagClass, tagNo);
            String found = ASN1Util.getTagText(taggedObject);
            throw new IllegalStateException("Expected " + expected + " tag but found " + found);
        }
        return taggedObject.getExplicitBaseTagged();
    }

    public static ASN1TaggedObject getExplicitContextBaseTagged(ASN1TaggedObject taggedObject, int tagNo) {
        return ASN1Util.getExplicitBaseTagged(taggedObject, 128, tagNo);
    }

    public static ASN1TaggedObject tryGetExplicitBaseTagged(ASN1TaggedObject taggedObject, int tagClass, int tagNo) {
        if (!taggedObject.hasTag(tagClass, tagNo)) {
            return null;
        }
        return taggedObject.getExplicitBaseTagged();
    }

    public static ASN1TaggedObject tryGetExplicitContextBaseTagged(ASN1TaggedObject taggedObject, int tagNo) {
        return ASN1Util.tryGetExplicitBaseTagged(taggedObject, 128, tagNo);
    }

    public static ASN1Primitive getBaseUniversal(ASN1TaggedObject taggedObject, int tagClass, int tagNo, boolean declaredExplicit, int baseTagNo) {
        if (!taggedObject.hasTag(tagClass, tagNo)) {
            String expected = ASN1Util.getTagText(tagClass, tagNo);
            String found = ASN1Util.getTagText(taggedObject);
            throw new IllegalStateException("Expected " + expected + " tag but found " + found);
        }
        return taggedObject.getBaseUniversal(declaredExplicit, baseTagNo);
    }

    public static ASN1Primitive getContextBaseUniversal(ASN1TaggedObject taggedObject, int tagNo, boolean declaredExplicit, int baseTagNo) {
        return ASN1Util.getBaseUniversal(taggedObject, 128, tagNo, declaredExplicit, baseTagNo);
    }

    public static ASN1Primitive tryGetBaseUniversal(ASN1TaggedObject taggedObject, int tagClass, int tagNo, boolean declaredExplicit, int baseTagNo) {
        if (!taggedObject.hasTag(tagClass, tagNo)) {
            return null;
        }
        return taggedObject.getBaseUniversal(declaredExplicit, baseTagNo);
    }

    public static ASN1Primitive tryGetContextBaseUniversal(ASN1TaggedObject taggedObject, int tagNo, boolean declaredExplicit, int baseTagNo) {
        return ASN1Util.tryGetBaseUniversal(taggedObject, 128, tagNo, declaredExplicit, baseTagNo);
    }

    public static ASN1Encodable parseBaseUniversal(ASN1TaggedObjectParser taggedObjectParser, int tagClass, int tagNo, boolean declaredExplicit, int baseTagNo) throws IOException {
        if (!taggedObjectParser.hasTag(tagClass, tagNo)) {
            String expected = ASN1Util.getTagText(tagClass, tagNo);
            String found = ASN1Util.getTagText(taggedObjectParser);
            throw new ASN1Exception("Expected " + expected + " tag but found " + found);
        }
        return taggedObjectParser.parseBaseUniversal(declaredExplicit, baseTagNo);
    }

    public static ASN1Encodable parseContextBaseUniversal(ASN1TaggedObjectParser taggedObjectParser, int tagNo, boolean declaredExplicit, int baseTagNo) throws IOException {
        return ASN1Util.parseBaseUniversal(taggedObjectParser, 128, tagNo, declaredExplicit, baseTagNo);
    }

    public static ASN1Encodable tryParseBaseUniversal(ASN1TaggedObjectParser taggedObjectParser, int tagClass, int tagNo, boolean declaredExplicit, int baseTagNo) throws IOException {
        if (!taggedObjectParser.hasTag(tagClass, tagNo)) {
            return null;
        }
        return taggedObjectParser.parseBaseUniversal(declaredExplicit, baseTagNo);
    }

    public static ASN1Encodable tryParseContextBaseUniversal(ASN1TaggedObjectParser taggedObjectParser, int tagNo, boolean declaredExplicit, int baseTagNo) throws IOException {
        return ASN1Util.tryParseBaseUniversal(taggedObjectParser, 128, tagNo, declaredExplicit, baseTagNo);
    }
}

