/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.coding.asn1;

import com.xdja.jce.coding.asn1.ASN1BitString;
import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1EncodableVector;
import com.xdja.jce.coding.asn1.ASN1External;
import com.xdja.jce.coding.asn1.ASN1OctetString;
import com.xdja.jce.coding.asn1.ASN1OutputStream;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.ASN1Sequence;
import com.xdja.jce.coding.asn1.ASN1Set;
import com.xdja.jce.coding.asn1.BERBitString;
import com.xdja.jce.coding.asn1.BEROctetString;
import com.xdja.jce.coding.asn1.DERBitString;
import com.xdja.jce.coding.asn1.DERExternal;
import com.xdja.jce.coding.asn1.DEROctetString;
import com.xdja.jce.coding.asn1.DEROutputStream;
import com.xdja.jce.coding.asn1.DLSet;
import java.io.IOException;

public class DERSequence
extends ASN1Sequence {
    private int contentsLength = -1;

    public static DERSequence convert(ASN1Sequence seq) {
        return (DERSequence)seq.toDERObject();
    }

    public DERSequence() {
    }

    public DERSequence(ASN1Encodable element) {
        super(element);
    }

    public DERSequence(ASN1EncodableVector elementVector) {
        super(elementVector);
    }

    public DERSequence(ASN1Encodable[] elements) {
        super(elements);
    }

    DERSequence(ASN1Encodable[] elements, boolean clone) {
        super(elements, clone);
    }

    private int getContentsLength() throws IOException {
        if (this.contentsLength < 0) {
            int count = this.elements.length;
            int totalLength = 0;
            for (int i = 0; i < count; ++i) {
                ASN1Primitive derObject = this.elements[i].toASN1Primitive().toDERObject();
                totalLength += derObject.encodedLength(true);
            }
            this.contentsLength = totalLength;
        }
        return this.contentsLength;
    }

    @Override
    int encodedLength(boolean withTag) throws IOException {
        return ASN1OutputStream.getLengthOfEncodingDL(withTag, this.getContentsLength());
    }

    @Override
    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        if (withTag) {
            out.write(48);
        }
        DEROutputStream derOut = out.getDERSubStream();
        int count = this.elements.length;
        if (this.contentsLength >= 0 || count > 16) {
            out.writeDL(this.getContentsLength());
            for (int i = 0; i < count; ++i) {
                ASN1Primitive derObject = this.elements[i].toASN1Primitive().toDERObject();
                derObject.encode(derOut, true);
            }
        } else {
            int i;
            int totalLength = 0;
            ASN1Primitive[] derObjects = new ASN1Primitive[count];
            for (i = 0; i < count; ++i) {
                ASN1Primitive derObject;
                derObjects[i] = derObject = this.elements[i].toASN1Primitive().toDERObject();
                totalLength += derObject.encodedLength(true);
            }
            this.contentsLength = totalLength;
            out.writeDL(totalLength);
            for (i = 0; i < count; ++i) {
                derObjects[i].encode(derOut, true);
            }
        }
    }

    @Override
    ASN1BitString toASN1BitString() {
        return new DERBitString(BERBitString.flattenBitStrings(this.getConstructedBitStrings()), false);
    }

    @Override
    ASN1External toASN1External() {
        return new DERExternal(this);
    }

    @Override
    ASN1OctetString toASN1OctetString() {
        return new DEROctetString(BEROctetString.flattenOctetStrings(this.getConstructedOctetStrings()));
    }

    @Override
    ASN1Set toASN1Set() {
        return new DLSet(false, this.toArrayInternal());
    }

    @Override
    ASN1Primitive toDERObject() {
        return this;
    }

    @Override
    ASN1Primitive toDLObject() {
        return this;
    }
}

