/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.coding.asn1;

import com.xdja.jce.coding.asn1.ASN1BitString;
import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1EncodableVector;
import com.xdja.jce.coding.asn1.ASN1External;
import com.xdja.jce.coding.asn1.ASN1InputStream;
import com.xdja.jce.coding.asn1.ASN1OctetString;
import com.xdja.jce.coding.asn1.ASN1OutputStream;
import com.xdja.jce.coding.asn1.ASN1ParsingException;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.ASN1Sequence;
import com.xdja.jce.coding.asn1.ASN1Set;
import com.xdja.jce.coding.asn1.LazyConstructionEnumeration;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;

class LazyEncodedSequence
extends ASN1Sequence {
    private byte[] encoded;

    LazyEncodedSequence(byte[] encoded) throws IOException {
        this.encoded = encoded;
    }

    @Override
    public synchronized ASN1Encodable getObjectAt(int index) {
        this.force();
        return super.getObjectAt(index);
    }

    @Override
    public synchronized Enumeration getObjects() {
        if (null != this.encoded) {
            return new LazyConstructionEnumeration(this.encoded);
        }
        return super.getObjects();
    }

    @Override
    public synchronized int hashCode() {
        this.force();
        return super.hashCode();
    }

    @Override
    public synchronized Iterator<ASN1Encodable> iterator() {
        this.force();
        return super.iterator();
    }

    @Override
    public synchronized int size() {
        this.force();
        return super.size();
    }

    @Override
    public synchronized ASN1Encodable[] toArray() {
        this.force();
        return super.toArray();
    }

    @Override
    ASN1Encodable[] toArrayInternal() {
        this.force();
        return super.toArrayInternal();
    }

    @Override
    synchronized int encodedLength(boolean withTag) throws IOException {
        if (null != this.encoded) {
            return ASN1OutputStream.getLengthOfEncodingDL(withTag, this.encoded.length);
        }
        return super.toDLObject().encodedLength(withTag);
    }

    @Override
    synchronized void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        if (null != this.encoded) {
            out.writeEncodingDL(withTag, 48, this.encoded);
        } else {
            super.toDLObject().encode(out, withTag);
        }
    }

    @Override
    ASN1BitString toASN1BitString() {
        return ((ASN1Sequence)this.toDLObject()).toASN1BitString();
    }

    @Override
    ASN1External toASN1External() {
        return ((ASN1Sequence)this.toDLObject()).toASN1External();
    }

    @Override
    ASN1OctetString toASN1OctetString() {
        return ((ASN1Sequence)this.toDLObject()).toASN1OctetString();
    }

    @Override
    ASN1Set toASN1Set() {
        return ((ASN1Sequence)this.toDLObject()).toASN1Set();
    }

    @Override
    synchronized ASN1Primitive toDERObject() {
        this.force();
        return super.toDERObject();
    }

    @Override
    synchronized ASN1Primitive toDLObject() {
        this.force();
        return super.toDLObject();
    }

    private void force() {
        if (null != this.encoded) {
            ASN1InputStream aIn = new ASN1InputStream(this.encoded, true);
            try {
                ASN1EncodableVector v = aIn.readVector();
                aIn.close();
                this.elements = v.takeElements();
                this.encoded = null;
            }
            catch (IOException e) {
                throw new ASN1ParsingException("malformed ASN.1: " + e, e);
            }
        }
    }
}

