/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.coding.asn1;

import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1OutputStream;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.ASN1String;
import com.xdja.jce.coding.asn1.ASN1TaggedObject;
import com.xdja.jce.coding.asn1.ASN1UniversalType;
import com.xdja.jce.coding.asn1.DEROctetString;
import com.xdja.jce.coding.asn1.DERVideotexString;
import com.xdja.jce.core.util.Arrays;
import com.xdja.jce.core.util.Strings;
import java.io.IOException;

public abstract class ASN1VideotexString
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1VideotexString.class, 21){

        @Override
        ASN1Primitive fromImplicitPrimitive(DEROctetString octetString) {
            return ASN1VideotexString.createPrimitive(octetString.getOctets());
        }
    };
    final byte[] contents;

    public static ASN1VideotexString getInstance(Object obj) {
        ASN1Primitive primitive;
        if (obj == null || obj instanceof ASN1VideotexString) {
            return (ASN1VideotexString)obj;
        }
        if (obj instanceof ASN1Encodable && (primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1VideotexString) {
            return (ASN1VideotexString)primitive;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1VideotexString)TYPE.fromByteArray((byte[])obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1VideotexString getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        return (ASN1VideotexString)TYPE.getContextInstance(taggedObject, explicit);
    }

    ASN1VideotexString(byte[] contents, boolean clone) {
        this.contents = clone ? Arrays.clone((byte[])contents) : contents;
    }

    public final byte[] getOctets() {
        return Arrays.clone((byte[])this.contents);
    }

    @Override
    final boolean isConstructed() {
        return false;
    }

    @Override
    final int encodedLength(boolean withTag) {
        return ASN1OutputStream.getLengthOfEncodingDL(withTag, this.contents.length);
    }

    @Override
    final void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        out.writeEncodingDL(withTag, 21, this.contents);
    }

    @Override
    final boolean asn1Equals(ASN1Primitive other) {
        if (!(other instanceof ASN1VideotexString)) {
            return false;
        }
        ASN1VideotexString that = (ASN1VideotexString)other;
        return Arrays.areEqual((byte[])this.contents, (byte[])that.contents);
    }

    @Override
    public final int hashCode() {
        return Arrays.hashCode((byte[])this.contents);
    }

    @Override
    public final String getString() {
        return Strings.fromByteArray((byte[])this.contents);
    }

    static ASN1VideotexString createPrimitive(byte[] contents) {
        return new DERVideotexString(contents, false);
    }
}

