/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.coding.asn1;

import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1EncodableVector;
import com.xdja.jce.coding.asn1.ASN1External;
import com.xdja.jce.coding.asn1.ASN1Integer;
import com.xdja.jce.coding.asn1.ASN1ObjectIdentifier;
import com.xdja.jce.coding.asn1.ASN1OutputStream;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.DERFactory;
import com.xdja.jce.coding.asn1.DERSequence;
import com.xdja.jce.coding.asn1.DERTaggedObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERExternal
extends ASN1External {
    public DERExternal(ASN1EncodableVector vector) {
        this(DERFactory.createSequence(vector));
    }

    public DERExternal(DERSequence sequence) {
        super(sequence);
    }

    public DERExternal(ASN1ObjectIdentifier directReference, ASN1Integer indirectReference, ASN1Primitive dataValueDescriptor, DERTaggedObject externalData) {
        this(directReference, indirectReference, dataValueDescriptor, externalData.getTagNo(), externalData.toASN1Primitive());
    }

    public DERExternal(ASN1ObjectIdentifier directReference, ASN1Integer indirectReference, ASN1Primitive dataValueDescriptor, int encoding, ASN1Primitive externalData) {
        super(directReference, indirectReference, dataValueDescriptor, encoding, externalData);
    }

    @Override
    ASN1Primitive toDERObject() {
        return this;
    }

    @Override
    ASN1Primitive toDLObject() {
        return this;
    }

    @Override
    int encodedLength(boolean withTag) throws IOException {
        int contentsLength = 0;
        if (this.directReference != null) {
            contentsLength += this.directReference.encodedLength(true);
        }
        if (this.indirectReference != null) {
            contentsLength += this.indirectReference.encodedLength(true);
        }
        if (this.dataValueDescriptor != null) {
            contentsLength += this.dataValueDescriptor.toDERObject().encodedLength(true);
        }
        return ASN1OutputStream.getLengthOfEncodingDL(withTag, contentsLength += new DERTaggedObject(true, this.encoding, (ASN1Encodable)this.externalContent).encodedLength(true));
    }

    @Override
    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = ASN1OutputStream.create(bOut, "DER");
        if (this.directReference != null) {
            aOut.writePrimitive(this.directReference, true);
        }
        if (this.indirectReference != null) {
            aOut.writePrimitive(this.indirectReference, true);
        }
        if (this.dataValueDescriptor != null) {
            aOut.writePrimitive(this.dataValueDescriptor, true);
        }
        aOut.writePrimitive(new DERTaggedObject(true, this.encoding, (ASN1Encodable)this.externalContent), true);
        aOut.flushInternal();
        out.writeEncodingDL(withTag, 40, bOut.toByteArray());
    }
}

