/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.coding.asn1.cryptlib;

import com.xdja.jce.coding.asn1.ASN1EncodableVector;
import com.xdja.jce.coding.asn1.ASN1Integer;
import com.xdja.jce.coding.asn1.ASN1Object;
import com.xdja.jce.coding.asn1.ASN1OctetString;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.ASN1Sequence;
import com.xdja.jce.coding.asn1.DEROctetString;
import com.xdja.jce.coding.asn1.DERSequence;
import com.xdja.jce.core.util.BigIntegers;
import java.math.BigInteger;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASN1SM2Cipher
extends ASN1Object {
    private static Logger logger = LoggerFactory.getLogger(ASN1SM2Cipher.class);
    private ASN1Integer xCoordinate;
    private ASN1Integer yCoordinate;
    private ASN1OctetString hash;
    private ASN1OctetString cipherText;

    public static ASN1SM2Cipher getInstance(Object o) {
        if (o instanceof ASN1SM2Cipher) {
            return (ASN1SM2Cipher)o;
        }
        if (o != null) {
            return new ASN1SM2Cipher(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public ASN1SM2Cipher(ASN1Sequence sm2Asn1Sequence) {
        Enumeration e = sm2Asn1Sequence.getObjects();
        this.xCoordinate = ASN1Integer.getInstance(e.nextElement());
        this.yCoordinate = ASN1Integer.getInstance(e.nextElement());
        this.hash = ASN1OctetString.getInstance(e.nextElement());
        this.cipherText = ASN1OctetString.getInstance(e.nextElement());
    }

    public ASN1SM2Cipher(ASN1Integer xCoordinate, ASN1Integer yCoordinate, ASN1OctetString hash, ASN1OctetString cipherText) {
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        this.hash = hash;
        this.cipherText = cipherText;
    }

    public ASN1SM2Cipher(byte[] x, byte[] y, byte[] hash, byte[] cipherText) {
        this.xCoordinate = new ASN1Integer(BigIntegers.fromUnsignedByteArray((byte[])x));
        this.yCoordinate = new ASN1Integer(BigIntegers.fromUnsignedByteArray((byte[])y));
        this.hash = new DEROctetString(hash);
        this.cipherText = new DEROctetString(cipherText);
    }

    public BigInteger getxCoordinate() {
        return this.xCoordinate.getPositiveValue();
    }

    public BigInteger getyCoordinate() {
        return this.yCoordinate.getPositiveValue();
    }

    public byte[] getHash() {
        return this.hash.getOctets();
    }

    public byte[] getCipherText() {
        return this.cipherText.getOctets();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.xCoordinate);
        vector.add(this.yCoordinate);
        vector.add(this.hash);
        vector.add(this.cipherText);
        return new DERSequence(vector);
    }
}

