package com.xdja.jce.crypto.provider;

import com.xdja.jce.core.annotion.Order;
import com.xdja.jce.core.provider.DeviceProvider;
import com.xdja.jce.core.provider.DeviceProviderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.Provider;

/**
 * @Author:ggp
 * @Date:2021/7/1 16:40
 * @Description:
 */
@Order(5)
public class SoftProvider extends DeviceProvider {
    private static Logger logger = LoggerFactory.getLogger(SoftProvider.class);
    public static final String PROVIDER_NAME = "SoftProvider";
    public static final double version = 0.1;
    public static final String info = "SOFT Provider v0.1";



    public SoftProvider() {
        super(PROVIDER_NAME, info, version);
    }

    public void setup(Provider provider, DeviceProviderConfig config) {
        //xdja-jce-base
        //证书工厂
        putService(DeviceProvider.ENGINE_TYPE_CERT,"X509","com.xdja.jce.base.x509.X509CertificateFactory");
        //秘钥工厂
        putService(DeviceProvider.ENGINE_TYPE_KEY,"EC","com.xdja.jce.base.key.ECKeyFactoryEngine$ECEngine");
        putService(DeviceProvider.ENGINE_TYPE_KEY,"RSA","com.xdja.jce.base.rsa.KeyFactorySpi");
        //keystore
        putService(DeviceProvider.ENGINE_TYPE_KEYSTORE,"BKS","com.xdja.jce.base.keystore.BcKeyStoreSpi$Std");
        putService(DeviceProvider.ENGINE_TYPE_KEYSTORE,"BKS-V1","com.xdja.jce.base.keystore.BcKeyStoreSpi$Version1");
        putService(DeviceProvider.ENGINE_TYPE_KEYSTORE,"BouncyCastle","com.xdja.jce.base.keystore.BcKeyStoreSpi$BouncyCastleStore");
        //keystore需要的两种对称算法
        putService(DeviceProvider.ENGINE_TYPE_CIPHER,"Twofish","com.xdja.jce.base.cipher.engine.TwofishEngine");
        putService(DeviceProvider.ENGINE_TYPE_CIPHER,"DESede","com.xdja.jce.base.cipher.engine.DESedeEngine");
        //随机数
        putService(DeviceProvider.ENGINE_TYPE_RANDOM,"Default","com.xdja.jce.base.random.DRBG$Default");



        //xdja-jce-hash
        //hash
        putService(DeviceProvider.ENGINE_TYPE_DIGEST,"SM3","com.xdja.jce.hash.engine.SM3Digest");
        putService(DeviceProvider.ENGINE_TYPE_DIGEST,"SHA-1","com.xdja.jce.hash.engine.SHA1Digest");
        putService(DeviceProvider.ENGINE_TYPE_DIGEST,"SHA256","com.xdja.jce.hash.engine.SHA256Digest");
        putService(DeviceProvider.ENGINE_TYPE_DIGEST,"SHA512","com.xdja.jce.hash.engine.SHA512Digest");

        //softProvider
        //对称算法
        putService(DeviceProvider.ENGINE_TYPE_CIPHER,"SM4","com.xdja.jce.crypto.soft.engine.symmetric.SM4Engine");
        //keypair生成器
        putService(DeviceProvider.ENGINE_TYPE_KEYPAIR,"EC","com.xdja.jce.crypto.soft.engine.keypair.ECKeyPairGeneratorEngine");
        putService(DeviceProvider.ENGINE_TYPE_KEYPAIR,"RSA","com.xdja.jce.crypto.soft.engine.keypair.RSAKeyPairGeneratorEngine");
        //非对称算法
        putService(DeviceProvider.ENGINE_TYPE_ASYMMETRIC,"SM2","com.xdja.jce.crypto.soft.engine.asymmetric.SM2Engine");
        putService(DeviceProvider.ENGINE_TYPE_ASYMMETRIC,"RSA","com.xdja.jce.base.rsa.engine.RSABlindedEngine");
        //签名  RSA 只需要实现加密解密即可默认使用pss签名
        putService(DeviceProvider.ENGINE_TYPE_SIGNER,"SM3WITHSM2","com.xdja.jce.crypto.soft.engine.signer.SM2Signer");

    }



}
