/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.crypto.vhsm.engine.asymmetric;

import com.xdja.alg.RSAPrivateKey;
import com.xdja.alg.RSAPublicKey;
import com.xdja.alg.XdjaCryptoEx;
import com.xdja.jce.base.cipher.AsymmetricCipher;
import com.xdja.jce.base.encodings.PKCS1Encoding;
import com.xdja.jce.base.params.CipherParameters;
import com.xdja.jce.base.params.ParametersWithRandom;
import com.xdja.jce.base.params.RSAKeyParameters;
import com.xdja.jce.base.params.RSAPrivateCrtKeyParameters;
import com.xdja.jce.base.rsa.engine.RSACoreEngine;
import com.xdja.jce.base.util.ArraysUtils;
import com.xdja.jce.core.exception.InvalidCipherTextException;
import com.xdja.jce.core.util.BigIntegers;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAEngine
implements AsymmetricCipher {
    private boolean forEncryption;
    private RSAKeyParameters key;
    private Logger logger = LoggerFactory.getLogger(RSAEngine.class);
    private RSACoreEngine core = new RSACoreEngine();

    public void init(boolean forEncryption, CipherParameters param) {
        this.forEncryption = forEncryption;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (RSAKeyParameters)rParam.getParameters();
        } else {
            this.key = (RSAKeyParameters)param;
        }
        this.core.init(forEncryption, param);
    }

    public int getBlockSize() {
        int bitSize = this.key.getModulus().bitLength();
        if (this.forEncryption) {
            return (bitSize + 7) / 8 - 1;
        }
        return (bitSize + 7) / 8;
    }

    public int getOutputSize(int inputLen) {
        int bitSize = this.key.getModulus().bitLength();
        if (this.forEncryption) {
            return (bitSize + 7) / 8;
        }
        return (bitSize + 7) / 8 - 1;
    }

    public byte[] processBlock(byte[] in, int inOff, int len) throws InvalidCipherTextException {
        byte[] result;
        ArraysUtils.printHexBinary((Logger)this.logger, (String)"VHSM-RSA in ", (byte[])in);
        this.logger.debug("VHSM-RSA inOff {}", (Object)inOff);
        this.logger.debug("VHSM-RSA len {}", (Object)len);
        byte[] data = new byte[(this.key.getModulus().bitLength() + 7) / 8];
        BigInteger bigInput = this.core.convertInput(in, inOff, len);
        ArraysUtils.printHexBinary((Logger)this.logger, (String)"VHSM-RSA bigInput", (byte[])BigIntegers.asUnsignedByteArray((BigInteger)bigInput));
        System.arraycopy(BigIntegers.asUnsignedByteArray((BigInteger)bigInput), 0, data, data.length - len, len);
        if (this.key instanceof RSAPrivateCrtKeyParameters) {
            RSAPrivateKey privateKey = new RSAPrivateKey();
            RSAPrivateCrtKeyParameters k = (RSAPrivateCrtKeyParameters)this.key;
            privateKey.m = BigIntegers.asUnsignedByteArray((int)256, (BigInteger)k.getModulus());
            privateKey.e = BigIntegers.asUnsignedByteArray((int)256, (BigInteger)k.getPublicExponent());
            privateKey.d = BigIntegers.asUnsignedByteArray((int)256, (BigInteger)k.getExponent());
            privateKey.p = BigIntegers.asUnsignedByteArray((int)128, (BigInteger)k.getP());
            privateKey.q = BigIntegers.asUnsignedByteArray((int)128, (BigInteger)k.getQ());
            privateKey.dp = BigIntegers.asUnsignedByteArray((int)128, (BigInteger)k.getDP());
            privateKey.dq = BigIntegers.asUnsignedByteArray((int)128, (BigInteger)k.getDQ());
            privateKey.ce = BigIntegers.asUnsignedByteArray((int)128, (BigInteger)k.getQInv());
            privateKey.bits = this.key.getModulus().bitLength();
            result = XdjaCryptoEx.getInstance().rsaPrivateBlock(data, data.length, privateKey);
        } else {
            System.arraycopy(BigIntegers.asUnsignedByteArray((BigInteger)bigInput), 0, data, data.length - len, len);
            RSAPublicKey publicKey = new RSAPublicKey();
            publicKey.m = BigIntegers.asUnsignedByteArray((int)256, (BigInteger)this.key.getModulus());
            publicKey.e = BigIntegers.asUnsignedByteArray((int)256, (BigInteger)this.key.getExponent());
            publicKey.bits = this.key.getModulus().bitLength();
            result = XdjaCryptoEx.getInstance().rsaPublicBlock(data, data.length, publicKey);
        }
        if (null == result) {
            throw new RuntimeException("VHSM-RSA\u8fd0\u7b97" + (this.forEncryption ? "\u52a0\u5bc6" : "\u89e3\u5bc6") + "\u5931\u8d25,\u9519\u8bef\u7801\uff1a" + XdjaCryptoEx.getInstance().getErrorCode());
        }
        ArraysUtils.printHexBinary((Logger)this.logger, (String)"VHSM-RSA result ", (byte[])result);
        return this.core.convertOutput(BigIntegers.fromUnsignedByteArray((byte[])result));
    }

    public static class Wrapper
    implements AsymmetricCipher {
        private AsymmetricCipher engine = new PKCS1Encoding((AsymmetricCipher)new RSAEngine());

        public void init(boolean forEncryption, CipherParameters param) {
            this.engine.init(forEncryption, param);
        }

        public int getBlockSize() {
            return this.engine.getBlockSize();
        }

        public int getOutputSize(int inputLen) {
            return this.engine.getOutputSize(inputLen);
        }

        public byte[] processBlock(byte[] in, int inOff, int len) throws InvalidCipherTextException {
            return this.engine.processBlock(in, inOff, len);
        }
    }
}

