/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.crypto.vhsm.engine.digest;

import com.xdja.alg.XdjaCryptoEx;
import com.xdja.jce.base.util.ArraysUtils;
import com.xdja.jce.core.util.Memoable;
import com.xdja.jce.hash.digest.Digest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM3Digest
implements Digest,
Memoable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int DIGEST_LENGTH = 32;
    private byte[] in = new byte[0];
    private long[] hd;

    public SM3Digest() {
        this.init();
    }

    private void init() {
        this.hd = XdjaCryptoEx.getInstance().sm3Init();
        this.logger.debug("SM3Digest init hd[0] " + this.hd[0]);
        if (null == this.hd) {
            this.logger.error("VHSM--SM3\u7b97\u6cd5\u521d\u59cb\u5316\u5931\u8d25!\u9519\u8bef\u7801:" + XdjaCryptoEx.getInstance().getErrorCode());
        }
    }

    public SM3Digest(SM3Digest t) {
        this.copyIn(t);
    }

    public String getAlgorithmName() {
        return "SM3";
    }

    public int getDigestSize() {
        return 32;
    }

    public void update(byte in) {
        byte[] bytes = new byte[]{in};
        this.update(bytes, 0, bytes.length);
    }

    public void update(byte[] in, int inOff, int len) {
        if (null == in || in.length == 0 || len == 0) {
            return;
        }
        byte[] result = new byte[len];
        System.arraycopy(in, inOff, result, 0, len);
        while (len > 1024) {
            byte[] m = new byte[1024];
            System.arraycopy(result, 0, m, 0, m.length);
            boolean ret = XdjaCryptoEx.getInstance().sm3Update(this.hd, m, m.length);
            if (!ret) {
                this.logger.error("len " + len);
                this.logger.error("hd " + this.hd[0]);
                this.logger.error("VHSM--SM3\u7b97\u6cd5\u8fd0\u7b97\u5931\u8d25\uff01\u9519\u8bef\u7801:" + XdjaCryptoEx.getInstance().getErrorCode());
            }
            len -= 1024;
            byte[] dataNow = new byte[result.length - m.length];
            System.arraycopy(result, m.length, dataNow, 0, result.length - m.length);
            result = dataNow;
            this.addIn(m, 0, m.length);
        }
        boolean ret = XdjaCryptoEx.getInstance().sm3Update(this.hd, result, len);
        this.addIn(result, 0, len);
        if (!ret) {
            this.logger.error("len " + len);
            this.logger.error("hd " + this.hd[0]);
            this.logger.error("VHSM--SM3\u7b97\u6cd5\u8fd0\u7b97\u5931\u8d25\uff01\u9519\u8bef\u7801:" + XdjaCryptoEx.getInstance().getErrorCode());
        }
    }

    private void addIn(byte[] in, int inOff, int len) {
        byte[] out = new byte[this.in.length + len];
        System.arraycopy(this.in, 0, out, 0, this.in.length);
        System.arraycopy(in, inOff, out, this.in.length, len);
        this.in = out;
    }

    public int doFinal(byte[] out, int outOff) {
        if (outOff == 0) {
            XdjaCryptoEx.getInstance().sm3Final(this.hd, out);
        } else {
            byte[] result = new byte[32];
            System.arraycopy(out, outOff, result, 0, 32);
            XdjaCryptoEx.getInstance().sm3Final(this.hd, result);
            System.arraycopy(result, 0, out, outOff, 32);
        }
        if (null == out) {
            this.logger.error("VHSM--SM3\u8fd0\u7b97\u7ed3\u675f\u5931\u8d25!\u9519\u8bef\u7801\uff1a" + XdjaCryptoEx.getInstance().getErrorCode());
        }
        this.reset();
        return 32;
    }

    public void reset() {
        this.hd = XdjaCryptoEx.getInstance().sm3Init();
        this.in = new byte[0];
        if (null == this.hd) {
            this.logger.error("VHSM--SM3\u7b97\u6cd5\u521d\u59cb\u5316\u5931\u8d25!\u9519\u8bef\u7801:" + XdjaCryptoEx.getInstance().getErrorCode());
        }
    }

    public Memoable copy() {
        return new SM3Digest(this);
    }

    public void reset(Memoable other) {
        SM3Digest d = (SM3Digest)other;
        this.copyIn(d);
        d.in = new byte[0];
    }

    protected void copyIn(SM3Digest t) {
        this.init();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SM3Digest cony in  hd[0] " + t.hd[0]);
            this.logger.debug("SM3Digest init hd[0] " + this.hd[0]);
        }
        if (t.in != null && t.in.length > 0) {
            if (this.logger.isDebugEnabled()) {
                ArraysUtils.printHexBinary((Logger)this.logger, (String)"data in ", (byte[])t.in);
            }
            this.update(t.in, 0, t.in.length);
        }
    }
}

