/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.crypto.vhsm.engine.key;

import com.xdja.alg.RSAPrivateKey;
import com.xdja.alg.RSAPublicKey;
import com.xdja.alg.XdjaCryptoEx;
import com.xdja.jce.base.params.RSAKeyParameters;
import com.xdja.jce.base.params.RSAPrivateCrtKeyParameters;
import com.xdja.jce.base.rsa.BCRSAPrivateCrtKey;
import com.xdja.jce.base.rsa.BCRSAPublicKey;
import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.DERNull;
import com.xdja.jce.coding.asn1.pkcs.PKCSObjectIdentifiers;
import com.xdja.jce.coding.asn1.x509.AlgorithmIdentifier;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAKeyPairGeneratorEngine
extends KeyPairGenerator {
    private static final AlgorithmIdentifier PKCS_ALGID = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE);
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int keySize;

    public RSAKeyPairGeneratorEngine() {
        super("RSA");
    }

    @Override
    public void initialize(int keySize) {
        this.keySize = keySize;
    }

    @Override
    public KeyPair generateKeyPair() {
        KeyPair keyPair = null;
        RSAPublicKey publicKey = new RSAPublicKey();
        RSAPrivateKey privateKey = new RSAPrivateKey();
        boolean flag = XdjaCryptoEx.getInstance().rsaGenerateKeys(this.keySize, publicKey, privateKey);
        if (flag) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("RSA\u4ea7\u751f\u516c\u79c1\u94a5\u5bf9\u6210\u529f\uff01");
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("RSA\u4ea7\u751f\u516c\u79c1\u94a5\u5bf9\u5931\u8d25\uff01\u9519\u8bef\u7801\uff1a" + XdjaCryptoEx.getInstance().getErrorCode());
        }
        RSAPrivateCrtKeyParameters privateCrtKeyParameters = new RSAPrivateCrtKeyParameters(new BigInteger(1, privateKey.m), new BigInteger(1, privateKey.e), new BigInteger(1, privateKey.d), new BigInteger(1, privateKey.p), new BigInteger(1, privateKey.q), new BigInteger(1, privateKey.dp), new BigInteger(1, privateKey.dq), new BigInteger(1, privateKey.ce));
        RSAKeyParameters publicKeyParameters = new RSAKeyParameters(false, new BigInteger(1, publicKey.m), new BigInteger(1, publicKey.e));
        try {
            keyPair = new KeyPair((PublicKey)new BCRSAPublicKey(PKCS_ALGID, publicKeyParameters), (PrivateKey)new BCRSAPrivateCrtKey(PKCS_ALGID, privateCrtKeyParameters));
        }
        catch (Exception e) {
            this.logger.error("VHSM--\u6784\u9020RSA\u5bc6\u94a5\u5bf9\u5f02\u5e38");
            e.printStackTrace();
        }
        return keyPair;
    }
}

