/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.crypto.vhsm.engine.signer;

import com.xdja.alg.SM2PrivateKey;
import com.xdja.alg.SM2PublicKey;
import com.xdja.alg.SM2Signature;
import com.xdja.alg.XdjaCryptoEx;
import com.xdja.jce.base.io.ErasableOutputStream;
import com.xdja.jce.base.params.CipherParameters;
import com.xdja.jce.base.params.ECKeyParameters;
import com.xdja.jce.base.params.ECPrivateKeyParameters;
import com.xdja.jce.base.params.ECPublicKeyParameters;
import com.xdja.jce.base.params.ParametersWithID;
import com.xdja.jce.base.params.ParametersWithRandom;
import com.xdja.jce.base.signers.Signer;
import com.xdja.jce.base.util.ArraysUtils;
import com.xdja.jce.base.util.ConverUtils;
import com.xdja.jce.core.exception.CryptoException;
import com.xdja.jce.core.exception.DataLengthException;
import com.xdja.jce.core.util.BigIntegers;
import com.xdja.jce.core.util.encoders.Hex;
import com.xdja.jce.crypto.vhsm.engine.SM2Init;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM2Signer
extends SM2Init
implements Signer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ECKeyParameters ecKey;
    private byte[] userID;
    private ErasableOutputStream buffer = new ErasableOutputStream();

    public void init(boolean forSigning, CipherParameters param) {
        CipherParameters baseParam;
        if (param instanceof ParametersWithID) {
            baseParam = ((ParametersWithID)param).getParameters();
            this.userID = ((ParametersWithID)param).getID();
            if (this.userID.length >= 8192) {
                throw new IllegalArgumentException("SM2 user ID must be less than 2^16 bits long");
            }
        } else {
            baseParam = param;
            this.userID = Hex.decodeStrict((String)"31323334353637383132333435363738");
        }
        if (forSigning) {
            if (baseParam instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)baseParam;
                this.ecKey = (ECKeyParameters)rParam.getParameters();
            } else {
                this.ecKey = (ECKeyParameters)baseParam;
            }
        } else {
            this.ecKey = (ECKeyParameters)baseParam;
        }
    }

    public void update(byte b) {
        this.buffer.write((int)b);
    }

    public void update(byte[] in, int off, int len) {
        this.buffer.write(in, off, len);
    }

    public byte[] generateSignature() throws CryptoException, DataLengthException {
        SM2PrivateKey privateKey = new SM2PrivateKey();
        privateKey.d = BigIntegers.asUnsignedByteArray((int)32, (BigInteger)((ECPrivateKeyParameters)this.ecKey).getD());
        SM2Signature sm2Signature = XdjaCryptoEx.getInstance().sm2Sign(null, privateKey, this.userID, this.userID.length, this.buffer.getBuf(), this.buffer.size());
        this.reset();
        return this.fromVHSMSign(sm2Signature);
    }

    public boolean verifySignature(byte[] signature) {
        SM2Signature sm2Signature = this.toVHSMSign(signature);
        SM2PublicKey publicKey = new SM2PublicKey();
        publicKey.x = BigIntegers.asUnsignedByteArray((int)32, (BigInteger)((ECPublicKeyParameters)this.ecKey).getQ().getAffineXCoord().toBigInteger());
        publicKey.y = BigIntegers.asUnsignedByteArray((int)32, (BigInteger)((ECPublicKeyParameters)this.ecKey).getQ().getAffineYCoord().toBigInteger());
        if (this.logger.isDebugEnabled()) {
            ArraysUtils.printHexBinary((Logger)this.logger, (String)"buffer ", (byte[])this.buffer.getBuf());
            this.logger.debug("buffer.size {}", (Object)this.buffer.size());
            ArraysUtils.printHexBinary((Logger)this.logger, (String)"publicKey.x ", (byte[])publicKey.x);
            ArraysUtils.printHexBinary((Logger)this.logger, (String)"publicKey.y ", (byte[])publicKey.y);
            ArraysUtils.printHexBinary((Logger)this.logger, (String)"sm2Signature.r ", (byte[])sm2Signature.r);
            ArraysUtils.printHexBinary((Logger)this.logger, (String)"sm2Signature.s ", (byte[])sm2Signature.s);
        }
        boolean flag = XdjaCryptoEx.getInstance().sm2Verify(publicKey, this.userID, this.userID.length, this.buffer.getBuf(), this.buffer.size(), sm2Signature);
        this.reset();
        return flag;
    }

    public void reset() {
        this.buffer.erase();
    }

    private byte[] fromVHSMSign(SM2Signature sm2Signature) {
        try {
            return ConverUtils.derSignatureEncode((byte[])sm2Signature.r, (byte[])sm2Signature.s);
        }
        catch (Exception e) {
            throw new RuntimeException("from vhsm sign error", e);
        }
    }

    private SM2Signature toVHSMSign(byte[] signature) {
        try {
            BigInteger[] bigIntegers = ConverUtils.derSignatureDecode((byte[])signature);
            SM2Signature sm2Signature = new SM2Signature();
            sm2Signature.r = BigIntegers.asUnsignedByteArray((BigInteger)bigIntegers[0]);
            sm2Signature.s = BigIntegers.asUnsignedByteArray((BigInteger)bigIntegers[1]);
            return sm2Signature;
        }
        catch (Exception e) {
            throw new RuntimeException("to vhsm sign error", e);
        }
    }
}

