/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.crypto.vhsm.engine.symmetric;

import com.xdja.alg.XdjaCryptoEx;
import com.xdja.jce.base.cipher.BlockCipher;
import com.xdja.jce.base.params.CipherParameters;
import com.xdja.jce.base.params.KeyParameter;
import com.xdja.jce.base.util.ArraysUtils;
import com.xdja.jce.core.exception.DataLengthException;
import com.xdja.jce.core.exception.OutputLengthException;
import com.xdja.jce.core.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM4Engine
implements BlockCipher {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean forEncryption;
    private static final int BLOCK_SIZE = 16;
    private byte[] key;

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.forEncryption = forEncryption;
        if (params instanceof KeyParameter) {
            this.key = ((KeyParameter)params).getKey();
            if (this.key.length != 16) {
                throw new IllegalArgumentException("SM4 requires a 128 bit key");
            }
        } else {
            throw new IllegalArgumentException("invalid parameter passed to SM4 init - " + params.getClass().getName());
        }
    }

    public String getAlgorithmName() {
        return "SM4";
    }

    public int getBlockSize() {
        return 16;
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (null == this.key) {
            throw new IllegalStateException("sm4\u672a\u521d\u59cb\u5316");
        }
        if (inOff + 16 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 16 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        byte[] incopy = Arrays.copyOfRange((byte[])in, (int)inOff, (int)(inOff + 16));
        byte[] outcopy = new byte[16];
        if (this.forEncryption) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SM4_ENCRYPT");
                ArraysUtils.printHexBinary((Logger)this.logger, (String)"in ", (byte[])in);
                this.logger.debug("SM4_ENCRYPT");
                this.logger.debug("inOff: {}", (Object)inOff);
                ArraysUtils.printHexBinary((Logger)this.logger, (String)"out ", (byte[])out);
                this.logger.debug("outOff: {}", (Object)outOff);
                ArraysUtils.printHexBinary((Logger)this.logger, (String)"key  ", (byte[])this.key);
                ArraysUtils.printHexBinary((Logger)this.logger, (String)"incopy  ", (byte[])incopy);
            }
            XdjaCryptoEx.getInstance().sm4Ecb(this.key, 1, incopy.length, incopy, outcopy);
            ArraysUtils.printHexBinary((Logger)this.logger, (String)"outcopy  ", (byte[])outcopy);
        } else {
            if (this.logger.isDebugEnabled()) {
                ArraysUtils.printHexBinary((Logger)this.logger, (String)"in ", (byte[])in);
                this.logger.debug("SM4_DECRYPT");
                this.logger.debug("inOff: {}", (Object)inOff);
                ArraysUtils.printHexBinary((Logger)this.logger, (String)"out ", (byte[])out);
                this.logger.debug("outOff: {}", (Object)outOff);
                ArraysUtils.printHexBinary((Logger)this.logger, (String)"key  ", (byte[])this.key);
                ArraysUtils.printHexBinary((Logger)this.logger, (String)"incopy  ", (byte[])incopy);
            }
            XdjaCryptoEx.getInstance().sm4Ecb(this.key, 0, incopy.length, incopy, outcopy);
            ArraysUtils.printHexBinary((Logger)this.logger, (String)"outcopy  ", (byte[])outcopy);
        }
        System.arraycopy(outcopy, 0, out, outOff, outcopy.length);
        return 16;
    }

    public void reset() {
    }
}

