/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.alg;

import com.xdja.alg.RSAPrivateKey;
import com.xdja.alg.RSAPublicKey;
import com.xdja.alg.SM2PrivateKey;
import com.xdja.alg.SM2PublicKey;
import com.xdja.alg.SM2Signature;
import com.xdja.alg.XdjaCrypto;

public class XdjaCryptoEx {
    private static ThreadLocal<XdjaError> thread_error = new ThreadLocal();
    private XdjaCrypto xdjaCrypto = new XdjaCrypto();
    private static XdjaCryptoEx instance;

    private XdjaCryptoEx() {
    }

    public static XdjaCryptoEx getInstance() {
        if (null == instance) {
            instance = new XdjaCryptoEx();
        }
        return instance;
    }

    public String getVersion() {
        return this.xdjaCrypto.XALG_GetVersion();
    }

    public boolean sm2InitLUT(byte[] data) {
        int ret = this.xdjaCrypto.XALG_SM2InitLUT(data);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return false;
        }
        return true;
    }

    public boolean sm2Init() {
        int ret = this.xdjaCrypto.XALG_SM2Init();
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return false;
        }
        return true;
    }

    public boolean sm2Genkey(SM2PublicKey sm2PublicKey, SM2PrivateKey sm2PrivateKey) {
        int ret = this.xdjaCrypto.XALG_SM2Genkey(sm2PublicKey, sm2PrivateKey);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return false;
        }
        return true;
    }

    public SM2PublicKey sm2CalPublicKey(byte[] byPrivateKey) {
        SM2PublicKey sm2PublicKey = new SM2PublicKey();
        int ret = this.xdjaCrypto.XALG_SM2CalPublicKey(byPrivateKey, sm2PublicKey);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return sm2PublicKey;
    }

    public boolean sm2CheckPublicKey(SM2PublicKey publicKey) {
        int ret = this.xdjaCrypto.XALG_SM2CheckPublicKey(publicKey);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return false;
        }
        return true;
    }

    public boolean sm2CheckPrivateKey(SM2PrivateKey privateKey) {
        int ret = this.xdjaCrypto.XALG_SM2CheckPrivateKey(privateKey);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return false;
        }
        return true;
    }

    public boolean sm2CheckKey(SM2PublicKey pubKey, SM2PrivateKey priKey) {
        int ret = this.xdjaCrypto.XALG_SM2CheckKey(pubKey, priKey);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return false;
        }
        return true;
    }

    public byte[] sm2Encrypt(SM2PublicKey sm2PublicKey, byte[] dataIn, int inLen) {
        byte[] dataOut = new byte[inLen + 97];
        int[] outLen = new int[1];
        int ret = this.xdjaCrypto.XALG_SM2Encrypt(sm2PublicKey, dataIn, inLen, dataOut, outLen);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        byte[] dataEnc = new byte[outLen[0]];
        System.arraycopy(dataOut, 0, dataEnc, 0, outLen[0]);
        return dataEnc;
    }

    public byte[] sm2Decrypt(SM2PrivateKey sm2PrivateKey, byte[] dataEnc, int inLen) {
        if (null == dataEnc || dataEnc.length <= 97 || inLen < 97) {
            this.setErrorCode(this.getMethodName(), -11);
            return null;
        }
        byte[] dataOut = new byte[inLen - 97];
        int[] outLen = new int[1];
        int ret = this.xdjaCrypto.XALG_SM2Decrypt(sm2PrivateKey, dataEnc, inLen, dataOut, outLen);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        byte[] dataDec = new byte[outLen[0]];
        System.arraycopy(dataOut, 0, dataDec, 0, outLen[0]);
        return dataDec;
    }

    public SM2Signature sm2Sign(SM2PublicKey sm2PublicKey, SM2PrivateKey sm2PrivateKey, byte[] ids, int idsLen, byte[] dataIn, int inLen) {
        SM2Signature sm2Signature = new SM2Signature();
        int ret = this.xdjaCrypto.XALG_SM2Sign(sm2PublicKey, sm2PrivateKey, ids, idsLen, dataIn, inLen, sm2Signature);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return sm2Signature;
    }

    public boolean sm2Verify(SM2PublicKey sm2PublicKey, byte[] ids, int idsLen, byte[] dataIn, int inLen, SM2Signature sm2Signature) {
        int ret = this.xdjaCrypto.XALG_SM2Verify(sm2PublicKey, ids, idsLen, dataIn, inLen, sm2Signature);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return false;
        }
        return true;
    }

    public void sm2ThreadCleanup() {
        this.xdjaCrypto.XALG_SM2ThreadCleanup();
    }

    public long[] sm3Init() {
        long[] handle = new long[]{0L};
        int ret = this.xdjaCrypto.XALG_SM3Init(handle);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return handle;
    }

    public boolean sm3Update(long[] handle, byte[] dataIn, int inLen) {
        if (null == handle || 0L == handle[0]) {
            this.setErrorCode(this.getMethodName(), -11);
            return false;
        }
        int ret = this.xdjaCrypto.XALG_SM3Update(handle[0], dataIn, inLen);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return false;
        }
        return true;
    }

    public void sm3Final(long[] handle, byte[] out) {
        if (null == handle || 0L == handle[0]) {
            this.setErrorCode(this.getMethodName(), -11);
            return;
        }
        int ret = this.xdjaCrypto.XALG_SM3Final(out, handle[0]);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return;
        }
        handle[0] = 0L;
    }

    public void sm4Ecb(byte[] sm4PubKey, int type, int inLen, byte[] dataIn, byte[] dataOut) {
        int ret = this.xdjaCrypto.XALG_SM4Ecb(sm4PubKey, type, inLen, dataIn, dataOut);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return;
        }
    }

    public byte[] sm4Cbc(byte[] sm4PubKey, int type, int inLen, byte[] iv, byte[] dataIn) {
        byte[] dataOut = new byte[inLen];
        int ret = this.xdjaCrypto.XALG_SM4Cbc(sm4PubKey, type, inLen, iv, dataIn, dataOut);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return dataOut;
    }

    public byte[] sm4Ctr(byte[] sm4PubKey, int type, int inLen, byte[] iv, byte[] dataIn) {
        byte[] dataOut = new byte[inLen];
        int ret = this.xdjaCrypto.XALG_SM4Ctr(sm4PubKey, type, inLen, iv, dataIn, dataOut);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return dataOut;
    }

    public byte[] sm4PaddingEcb(byte[] sm4PubKey, int type, int paddingType, int inLen, byte[] dataIn) {
        byte[] dataOut;
        int[] outLen;
        if (1 == type) {
            int count = inLen / 16 + 1;
            outLen = new int[]{count * 16};
            dataOut = new byte[outLen[0]];
        } else {
            dataOut = new byte[inLen];
            outLen = new int[1];
        }
        int ret = this.xdjaCrypto.XALG_SM4PaddingEcb(sm4PubKey, type, paddingType, inLen, dataIn, dataOut, outLen);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        byte[] data = new byte[outLen[0]];
        System.arraycopy(dataOut, 0, data, 0, outLen[0]);
        return data;
    }

    public byte[] sm4PaddingCbc(byte[] sm4PubKey, int type, int paddingType, int inLen, byte[] iv, byte[] dataIn) {
        byte[] dataOut;
        int[] outLen;
        if (1 == type) {
            int count = inLen / 16 + 1;
            outLen = new int[]{count * 16};
            dataOut = new byte[outLen[0]];
        } else {
            dataOut = new byte[inLen];
            outLen = new int[1];
        }
        int ret = this.xdjaCrypto.XALG_SM4PaddingCbc(sm4PubKey, type, paddingType, inLen, iv, dataIn, dataOut, outLen);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        byte[] data = new byte[outLen[0]];
        System.arraycopy(dataOut, 0, data, 0, outLen[0]);
        return data;
    }

    public byte[] rsaPublicBlock(byte[] dataIn, int inLen, RSAPublicKey rsaPublicKey) {
        byte[] dataEnc = new byte[inLen];
        int[] outLen = new int[1];
        int ret = this.xdjaCrypto.XALG_RSAPublicBlock(dataIn, inLen, rsaPublicKey, dataEnc, outLen);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return dataEnc;
    }

    public byte[] rsaPrivateBlock(byte[] dataEnc, int inLen, RSAPrivateKey rsaPrivateKey) {
        byte[] dataDec = new byte[inLen];
        int[] outLen = new int[1];
        int ret = this.xdjaCrypto.XALG_RSAPrivateBlock(dataEnc, inLen, rsaPrivateKey, dataDec, outLen);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return dataDec;
    }

    public boolean rsaGenerateKeys(int rsaType, RSAPublicKey rsaPublicKey, RSAPrivateKey rsaPrivateKey) {
        int ret = this.xdjaCrypto.XALG_RSAGenerateKeys(rsaType, rsaPublicKey, rsaPrivateKey);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return false;
        }
        return true;
    }

    public byte[] rsaSign(byte[] input, int inputLen, RSAPrivateKey privateKey) {
        byte[] data = new byte[256];
        int[] outLen = new int[1];
        int ret = this.xdjaCrypto.XALG_RSASign(input, inputLen, privateKey, data, outLen);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        byte[] result = new byte[outLen[0]];
        System.arraycopy(data, 0, result, 0, outLen[0]);
        return result;
    }

    public boolean rsaVerify(byte[] sig, int sigLen, byte[] input, int inputLen, RSAPublicKey publicKey) {
        int ret = this.xdjaCrypto.XALG_RSAVerify(sig, sigLen, input, inputLen, publicKey);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return false;
        }
        return true;
    }

    public byte[] rsaEncrypt(byte[] input, int inputLen, RSAPublicKey publicKey) {
        byte[] data = new byte[256];
        int[] outLen = new int[1];
        int ret = this.xdjaCrypto.XALG_RSAEncrypt(input, inputLen, publicKey, data, outLen);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        byte[] result = new byte[outLen[0]];
        System.arraycopy(data, 0, result, 0, outLen[0]);
        return result;
    }

    public byte[] rsaDecrypt(byte[] input, int inputLen, RSAPrivateKey privateKey) {
        byte[] data = new byte[256];
        int[] outLen = new int[1];
        int ret = this.xdjaCrypto.XALG_RSADecrypt(input, inputLen, privateKey, data, outLen);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        byte[] result = new byte[outLen[0]];
        System.arraycopy(data, 0, result, 0, outLen[0]);
        return result;
    }

    public long[] digestInit(int alg) {
        long[] handle = new long[]{0L};
        int ret = this.xdjaCrypto.XALG_DigestInit(handle, alg);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return handle;
    }

    public boolean digestUpdate(long[] handle, int alg, byte[] dataIn, int inLen) {
        if (null == handle || 0L == handle[0]) {
            this.setErrorCode(this.getMethodName(), -11);
            return false;
        }
        int ret = this.xdjaCrypto.XALG_DigestUpdate(handle[0], alg, dataIn, inLen);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return false;
        }
        return true;
    }

    public byte[] digestFinal(long[] handle, int alg) {
        int[] outLen;
        byte[] dataOut;
        int ret;
        if (null == handle || 0L == handle[0]) {
            this.setErrorCode(this.getMethodName(), -11);
        }
        if ((ret = this.xdjaCrypto.XALG_DigestFinal(handle[0], alg, dataOut = new byte[32], outLen = new int[]{0})) != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        handle[0] = 0L;
        return dataOut;
    }

    public byte[] encrypt(int alg, byte[] key, int keyLen, int inLen, byte[] iv, byte[] dataIn) {
        byte[] dataOut = new byte[inLen];
        int ret = this.xdjaCrypto.XALG_Encrypt(alg, key, keyLen, inLen, iv, dataIn, dataOut);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return dataOut;
    }

    public byte[] decrypt(int alg, byte[] key, int keyLen, int inLen, byte[] iv, byte[] dataIn) {
        byte[] dataOut = new byte[inLen];
        int ret = this.xdjaCrypto.XALG_Decrypt(alg, key, keyLen, inLen, iv, dataIn, dataOut);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return dataOut;
    }

    public byte[] paddingEncrypt(int alg, int padding, byte[] key, int keyLen, int inLen, byte[] iv, byte[] dataIn) {
        byte[] dataOut = new byte[inLen + 32];
        int[] outLen = new int[1];
        int ret = this.xdjaCrypto.XALG_PaddingEncrypt(alg, padding, key, keyLen, inLen, iv, dataIn, dataOut, outLen);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        byte[] data = new byte[outLen[0]];
        System.arraycopy(dataOut, 0, data, 0, outLen[0]);
        return data;
    }

    public byte[] paddingDecrypt(int alg, int padding, byte[] key, int keyLen, int inLen, byte[] iv, byte[] dataIn) {
        byte[] dataOut = new byte[inLen];
        int[] outLen = new int[1];
        int ret = this.xdjaCrypto.XALG_PaddingDecrypt(alg, padding, key, keyLen, inLen, iv, dataIn, dataOut, outLen);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        byte[] data = new byte[outLen[0]];
        System.arraycopy(dataOut, 0, data, 0, outLen[0]);
        return data;
    }

    public void stringToByte(String data, byte[] arr, int[] len) {
        int i;
        for (i = 0; i < arr.length && 2 * (i + 1) <= data.length(); ++i) {
            arr[i] = (byte)Integer.parseInt(data.substring(i * 2, 2 * (i + 1)), 16);
        }
        if (len != null) {
            len[0] = i;
        }
    }

    public byte[] stringToByte(String data) {
        int size = data.length() / 2;
        byte[] arr = new byte[size];
        this.stringToByte(data, arr, null);
        return arr;
    }

    public String byteToString(byte[] arr, int pos, int len) {
        StringBuilder builder = new StringBuilder("");
        for (int i = pos; i < pos + len; ++i) {
            builder.append(String.format("%02X", arr[i]));
        }
        return builder.toString();
    }

    public String byteToString(byte[] arr, int len) {
        return this.byteToString(arr, 0, len);
    }

    public String byteToString(byte[] arr) {
        return this.byteToString(arr, 0, arr.length);
    }

    public SM2PublicKey byteToSM2PublicKey(byte[] point, int len) {
        SM2PublicKey pubKey = new SM2PublicKey();
        int ret = this.xdjaCrypto.XALG_ByteToSM2PublicKey(point, len, pubKey);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return pubKey;
    }

    public SM2PrivateKey byteToSM2PrivateKey(byte[] byPrivKey) {
        SM2PrivateKey privKey = new SM2PrivateKey();
        int ret = this.xdjaCrypto.XALG_ByteToSM2PrivateKey(byPrivKey, privKey);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return privKey;
    }

    public byte[] sm2PublicKeyToByte(SM2PublicKey pubKey) {
        byte[] byPubKey = new byte[65];
        int ret = this.xdjaCrypto.XALG_SM2PublicKeyToByte(pubKey, byPubKey);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return byPubKey;
    }

    public byte[] sm2PrivateKeyToByte(SM2PrivateKey privKey) {
        byte[] byPrivKey = new byte[32];
        int ret = this.xdjaCrypto.XALG_SM2PrivateKeyToByte(privKey, byPrivKey);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return byPrivKey;
    }

    public SM2PublicKey pemToSM2PublicKey(String strPubKey) {
        SM2PublicKey pubKey = new SM2PublicKey();
        int ret = this.xdjaCrypto.XALG_PemToSM2PublicKey(strPubKey, pubKey);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return pubKey;
    }

    public SM2PrivateKey pemToSM2PrivateKey(String strPrivKey) {
        SM2PrivateKey privKey = new SM2PrivateKey();
        int ret = this.xdjaCrypto.XALG_PemToSM2PrivateKey(strPrivKey, privKey);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return privKey;
    }

    public String sm2PublicKeyToPem(SM2PublicKey pubKey) {
        StringBuilder stringBuilder = new StringBuilder("");
        int ret = this.xdjaCrypto.XALG_SM2PublicKeyToPem(pubKey, stringBuilder);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return stringBuilder.toString();
    }

    public String sm2PrivateKeyToPem(SM2PrivateKey privKey) {
        StringBuilder stringBuilder = new StringBuilder("");
        int ret = this.xdjaCrypto.XALG_SM2PrivateKeyToPem(privKey, stringBuilder);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return stringBuilder.toString();
    }

    public SM2Signature byteToSM2Signature(byte[] rs) {
        SM2Signature sig = new SM2Signature();
        int ret = this.xdjaCrypto.XALG_ByteToSM2Signature(rs, sig);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return sig;
    }

    public byte[] sm2SignatureToByte(SM2Signature sig) {
        byte[] rs = new byte[64];
        int ret = this.xdjaCrypto.XALG_SM2SignatureToByte(sig, rs);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return rs;
    }

    public SM2Signature asn1ToSM2Signature(byte[] asn1, int len) {
        SM2Signature sig = new SM2Signature();
        int ret = this.xdjaCrypto.XALG_Asn1ToSM2Signature(asn1, len, sig);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return sig;
    }

    public byte[] sm2SignatureToAsn1(SM2Signature sig) {
        byte[] dataOut = new byte[72];
        int[] outLen = new int[1];
        int ret = this.xdjaCrypto.XALG_SM2SignatureToAsn1(sig, dataOut, outLen);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        byte[] asn1 = new byte[outLen[0]];
        System.arraycopy(dataOut, 0, asn1, 0, outLen[0]);
        return asn1;
    }

    public RSAPublicKey rsaExtractPublicKey(RSAPrivateKey privKey) {
        RSAPublicKey pubKey = new RSAPublicKey();
        int ret = this.xdjaCrypto.XALG_RSAExtractPublicKey(privKey, pubKey);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return pubKey;
    }

    public RSAPublicKey pemToRSAPublicKey(String strPubKey) {
        RSAPublicKey pubKey = new RSAPublicKey();
        int ret = this.xdjaCrypto.XALG_PemToRSAPublicKey(strPubKey, pubKey);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return pubKey;
    }

    public RSAPrivateKey pemToRSAPrivateKey(String strPrivKey) {
        RSAPrivateKey privKey = new RSAPrivateKey();
        int ret = this.xdjaCrypto.XALG_PemToRSAPrivateKey(strPrivKey, privKey);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return privKey;
    }

    public String rsaPublicKeyToPem(RSAPublicKey pubKey) {
        StringBuilder stringBuilder = new StringBuilder("");
        int ret = this.xdjaCrypto.XALG_RSAPublicKeyToPem(pubKey, stringBuilder);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return stringBuilder.toString();
    }

    public String rsaPrivateKeyToPem(RSAPrivateKey privKey) {
        StringBuilder stringBuilder = new StringBuilder("");
        int ret = this.xdjaCrypto.XALG_RSAPrivateKeyToPem(privKey, stringBuilder);
        if (ret != 0) {
            this.setErrorCode(this.getMethodName(), ret);
            return null;
        }
        return stringBuilder.toString();
    }

    private String getMethodName() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement targetElement = stackTrace[3];
        return targetElement.getMethodName() + "()";
    }

    private void setErrorCode(String funcName, int ret) {
        if (0 != ret) {
            XdjaError error = thread_error.get();
            if (error == null) {
                error = new XdjaError(funcName, ret);
                thread_error.set(error);
            } else {
                error.errorCode = ret;
                error.funcName = funcName;
            }
        }
    }

    public int getErrorCode() {
        XdjaError error = thread_error.get();
        if (error == null) {
            return 0;
        }
        return error.getErrorCode();
    }

    public String getFuncName() {
        XdjaError error = thread_error.get();
        if (error == null) {
            return "";
        }
        return error.getFuncName();
    }

    private class XdjaError {
        private int errorCode;
        private String funcName;

        public XdjaError(String funcName, int errorCode) {
            this.errorCode = errorCode;
            this.funcName = funcName;
        }

        int getErrorCode() {
            return this.errorCode;
        }

        String getFuncName() {
            return this.funcName;
        }

        protected void finalize() {
            XdjaCryptoEx.this.sm2ThreadCleanup();
        }
    }
}

