/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.crypto.vhsm.engine.asymmetric;

import com.xdja.alg.SM2PrivateKey;
import com.xdja.alg.SM2PublicKey;
import com.xdja.alg.XdjaCryptoEx;
import com.xdja.jce.base.cipher.AsymmetricCipher;
import com.xdja.jce.base.ec.ECPoint;
import com.xdja.jce.base.params.CipherParameters;
import com.xdja.jce.base.params.ECKeyParameters;
import com.xdja.jce.base.params.ECPrivateKeyParameters;
import com.xdja.jce.base.params.ECPublicKeyParameters;
import com.xdja.jce.base.params.Mode;
import com.xdja.jce.base.params.ParametersWithMode;
import com.xdja.jce.base.params.ParametersWithRandom;
import com.xdja.jce.base.util.ArraysUtils;
import com.xdja.jce.core.exception.InvalidCipherTextException;
import com.xdja.jce.core.util.Arrays;
import com.xdja.jce.core.util.BigIntegers;
import com.xdja.jce.core.util.encoders.Hex;
import com.xdja.jce.crypto.vhsm.engine.SM2Init;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM2Engine
extends SM2Init
implements AsymmetricCipher {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean forEncryption;
    private ECKeyParameters ecParams;
    private int curveLength;
    private Mode mode = Mode.C1C3C2;
    public static final int c1c2c3_to_c1c3c2 = 1;
    public static final int c1c3c2_to_c1c2c3 = 2;

    public void init(boolean forEncryption, CipherParameters param) {
        this.forEncryption = forEncryption;
        if (forEncryption) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            if (rParam.getParameters() instanceof ParametersWithMode) {
                ParametersWithMode mParams = (ParametersWithMode)rParam.getParameters();
                this.ecParams = (ECKeyParameters)mParams.getParameters();
                this.mode = mParams.getMode();
            } else {
                this.ecParams = (ECKeyParameters)rParam.getParameters();
            }
            ECPoint s = ((ECPublicKeyParameters)this.ecParams).getQ().multiply(this.ecParams.getParameters().getH());
            if (s.isInfinity()) {
                throw new IllegalArgumentException("invalid key: [h]Q at infinity");
            }
        } else if (param instanceof ParametersWithMode) {
            ParametersWithMode mParams = (ParametersWithMode)param;
            this.ecParams = (ECKeyParameters)mParams.getParameters();
            this.mode = mParams.getMode();
        } else {
            this.ecParams = (ECKeyParameters)param;
        }
        this.curveLength = (this.ecParams.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public int getBlockSize() {
        return Integer.MAX_VALUE;
    }

    public int getOutputSize(int inputLen) {
        return 0;
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] data = new byte[inLen];
        System.arraycopy(in, inOff, data, 0, inLen);
        byte[] result = null;
        if (this.forEncryption) {
            SM2PublicKey publicKey = new SM2PublicKey();
            publicKey.x = ((ECPublicKeyParameters)this.ecParams).getQ().getXCoord().getEncoded();
            publicKey.y = ((ECPublicKeyParameters)this.ecParams).getQ().getYCoord().getEncoded();
            if (this.logger.isDebugEnabled()) {
                ArraysUtils.printHexBinary((Logger)this.logger, (String)"publicKey.x ", (byte[])publicKey.x);
                ArraysUtils.printHexBinary((Logger)this.logger, (String)"publicKey.y ", (byte[])publicKey.y);
            }
            result = XdjaCryptoEx.getInstance().sm2Encrypt(publicKey, data, inLen);
            if (this.logger.isDebugEnabled()) {
                ArraysUtils.printHexBinary((Logger)this.logger, (String)"result ", (byte[])result);
                this.logger.debug("mode: {}", (Object)this.mode);
            }
            if (this.mode == Mode.C1C3C2) {
                result = this.converter(result, 2);
                ArraysUtils.printHexBinary((Logger)this.logger, (String)"result ", (byte[])result);
            }
        } else {
            SM2PrivateKey privateKey = new SM2PrivateKey();
            privateKey.d = BigIntegers.asUnsignedByteArray((int)32, (BigInteger)((ECPrivateKeyParameters)this.ecParams).getD());
            if (this.logger.isDebugEnabled()) {
                ArraysUtils.printHexBinary((Logger)this.logger, (String)"privateKey.d ", (byte[])privateKey.d);
                ArraysUtils.printHexBinary((Logger)this.logger, (String)"data ", (byte[])data);
                this.logger.debug("mode: {}", (Object)this.mode);
            }
            if (this.mode == Mode.C1C3C2) {
                data = this.converter(data, 1);
                ArraysUtils.printHexBinary((Logger)this.logger, (String)"data ", (byte[])data);
            }
            System.out.println("data!!!!!!!!!!!!!! " + Hex.toHexString((byte[])data));
            result = XdjaCryptoEx.getInstance().sm2Decrypt(privateKey, data, inLen);
        }
        if (null == result) {
            this.logger.error("VHSM--SM2\u7b97\u6cd5\u52a0\u89e3\u5bc6:" + this.forEncryption + ",\u9519\u8bef\u7801\uff1a" + XdjaCryptoEx.getInstance().getErrorCode());
            throw new InvalidCipherTextException();
        }
        return result;
    }

    private byte[] converter(byte[] src, int to) {
        byte[] c1 = new byte[65];
        byte[] c2 = new byte[src.length - 97];
        byte[] c3 = new byte[32];
        System.arraycopy(src, 0, c1, 0, c1.length);
        if (to == 1) {
            System.arraycopy(src, c1.length, c2, 0, c2.length);
            System.arraycopy(src, c1.length + c2.length, c3, 0, c3.length);
            return Arrays.concatenate((byte[])c1, (byte[])c3, (byte[])c2);
        }
        System.arraycopy(src, c1.length, c3, 0, c3.length);
        System.arraycopy(src, c1.length + c3.length, c2, 0, c2.length);
        return Arrays.concatenate((byte[])c1, (byte[])c2, (byte[])c3);
    }
}

